/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.sound;

import com.github.alexmodguy.alexscaves.client.sound.BlockEntityTickableSound;
import com.github.alexmodguy.alexscaves.server.block.blockentity.NuclearFurnaceBlockEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class NuclearFurnaceSound
extends BlockEntityTickableSound<NuclearFurnaceBlockEntity> {
    private final int criticality;
    private int fade = 0;

    public NuclearFurnaceSound(NuclearFurnaceBlockEntity furnace) {
        super(NuclearFurnaceSound.getSoundFromFurnaceCriticality(furnace.getCriticality()), furnace);
        this.f_119573_ = 0.1f;
        this.criticality = furnace.getCriticality();
    }

    private static SoundEvent getSoundFromFurnaceCriticality(int criticality) {
        return criticality >= 3 ? (SoundEvent)ACSoundRegistry.NUCLEAR_FURNACE_ACTIVE_SUPERCRITICAL.get() : (criticality == 2 ? (SoundEvent)ACSoundRegistry.NUCLEAR_FURNACE_ACTIVE_CRITICAL.get() : (criticality > 0 ? (SoundEvent)ACSoundRegistry.NUCLEAR_FURNACE_ACTIVE_SUBCRITICAL.get() : (SoundEvent)ACSoundRegistry.NUCLEAR_FURNACE_ACTIVE.get()));
    }

    public boolean m_7767_() {
        return !((NuclearFurnaceBlockEntity)this.blockEntity).m_58901_();
    }

    @Override
    public boolean isSameBlockEntity(NuclearFurnaceBlockEntity blockEntity) {
        return super.isSameBlockEntity(blockEntity) && this.criticality == blockEntity.getCriticality();
    }

    public void m_7788_() {
        if ((((NuclearFurnaceBlockEntity)this.blockEntity).isUndergoingFission() || this.criticality > 0) && this.criticality == ((NuclearFurnaceBlockEntity)this.blockEntity).getCriticality()) {
            this.f_119575_ = (double)((NuclearFurnaceBlockEntity)this.blockEntity).m_58899_().m_123341_() + 1.0;
            this.f_119576_ = (double)((NuclearFurnaceBlockEntity)this.blockEntity).m_58899_().m_123342_() + 1.0;
            this.f_119577_ = (double)((NuclearFurnaceBlockEntity)this.blockEntity).m_58899_().m_123343_() + 1.0;
            this.f_119574_ = 1.0f;
            if (this.fade > 0) {
                --this.fade;
            }
        } else {
            ++this.fade;
        }
        this.f_119573_ = Mth.m_14036_((float)(1.0f - (float)this.fade / 40.0f), (float)0.0f, (float)1.0f);
        if (this.fade > 40) {
            this.m_119609_();
        }
    }
}

