/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.misc;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public enum DefaultMapBackgrounds {
    DEFAULT,
    BORDER,
    WATER,
    FROZEN_OCEAN,
    PLAINS,
    DESERT,
    FOREST,
    JUNGLE,
    TAIGA,
    SNOWY,
    SNOWY_TAIGA,
    BADLANDS,
    MOUNTAIN,
    SNOWY_MOUNTAIN,
    ROOFED_FOREST,
    MUSHROOM,
    SWAMP,
    SAVANNA,
    ICE_SPIKES,
    BEACH,
    STONY_SHORE,
    DRIPSTONE_CAVES,
    LUSH_CAVES,
    DEEP_DARK,
    MAGNETIC_CAVES,
    PRIMORDIAL_CAVES,
    TOXIC_CAVES,
    ABYSSAL_CHASM,
    FORLORN_HOLLOWS,
    CANDY_CAVITY;

    private ResourceLocation texture;
    private static final HashMap<Integer, MapBackgroundTexture> TEXTURE_HASH_MAP;

    private static MapBackgroundTexture getBackgroundTexture(int id, ResourceLocation resourceLocation) {
        if (TEXTURE_HASH_MAP.containsKey(id)) {
            return TEXTURE_HASH_MAP.get(id);
        }
        MapBackgroundTexture simpleTexture = new MapBackgroundTexture(resourceLocation);
        Minecraft.m_91087_().m_91097_().m_118495_(resourceLocation, (AbstractTexture)simpleTexture);
        TEXTURE_HASH_MAP.put(id, simpleTexture);
        return simpleTexture;
    }

    public int getMapColor(int u, int v) {
        MapBackgroundTexture backgroundTexture;
        if (this.texture == null) {
            this.texture = new ResourceLocation("alexscaves", "textures/misc/map/" + this.name().toLowerCase(Locale.ROOT) + "_background.png");
        }
        return (backgroundTexture = DefaultMapBackgrounds.getBackgroundTexture(this.ordinal(), this.texture)).getNativeImage() == null ? 0 : DefaultMapBackgrounds.clampNativeImg(backgroundTexture.getNativeImage(), u, v);
    }

    private static int clampNativeImg(NativeImage nativeImage, int u, int v) {
        return nativeImage.m_84985_(u % nativeImage.m_84982_(), v % nativeImage.m_85084_());
    }

    static {
        TEXTURE_HASH_MAP = new HashMap();
    }

    public static class MapBackgroundTexture
    extends SimpleTexture {
        private NativeImage nativeImage;

        public MapBackgroundTexture(ResourceLocation resourceLocation) {
            super(resourceLocation);
        }

        public NativeImage getNativeImage() {
            return this.nativeImage;
        }

        public void m_6704_(ResourceManager resourceManager) throws IOException {
            super.m_6704_(resourceManager);
            this.nativeImage = this.m_6335_(resourceManager).m_118158_();
        }
    }
}

