/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.ACBoatChestModel;
import com.github.alexmodguy.alexscaves.client.model.ACBoatModel;
import com.github.alexmodguy.alexscaves.client.model.PewenBoatModel;
import com.github.alexmodguy.alexscaves.client.model.ThornwoodBoatModel;
import com.github.alexmodguy.alexscaves.server.entity.util.AlexsCavesBoat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class AlexsCavesBoatRenderer<T extends Boat>
extends EntityRenderer<T> {
    private final HashMap<AlexsCavesBoat.Type, ResourceLocation> textureMap = new HashMap();
    private final HashMap<AlexsCavesBoat.Type, ACBoatModel> modelMap = new HashMap();
    private static final ResourceLocation CHEST_TEXTURE = new ResourceLocation("alexscaves", "textures/entity/boat/chest.png");
    private static final ACBoatChestModel CHEST_MODEL = new ACBoatChestModel();
    private final boolean isChest;

    public AlexsCavesBoatRenderer(EntityRendererProvider.Context context, boolean isChest) {
        super(context);
        for (AlexsCavesBoat.Type type : AlexsCavesBoat.Type.values()) {
            this.textureMap.put(type, new ResourceLocation("alexscaves", "textures/entity/boat/" + type.getName() + "_boat.png"));
        }
        this.modelMap.put(AlexsCavesBoat.Type.PEWEN, new PewenBoatModel());
        this.modelMap.put(AlexsCavesBoat.Type.THORNWOOD, new ThornwoodBoatModel());
        this.isChest = isChest;
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        float f2;
        ACBoatModel model = this.modelMap.get((Object)((AlexsCavesBoat)entity).getACBoatType());
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 1.5f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        float f = (float)entity.m_38385_() - partialTicks;
        float f1 = entity.m_38384_() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)entity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = entity.m_38352_(partialTicks)), (float)0.0f)) {
            poseStack.m_252781_(new Quaternionf().setAngleAxis(entity.m_38352_(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        if (this.isChest) {
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, -0.25f, 0.5f);
            CHEST_MODEL.m_7695_(poseStack, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)CHEST_TEXTURE)), packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
        model.m_6973_((Entity)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
        model.m_7695_(poseStack, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.m_5842_()) {
            VertexConsumer vertexconsumer1 = bufferIn.m_6299_(RenderType.m_110478_());
            model.getWaterMask().render(poseStack, vertexconsumer1, packedLightIn, OverlayTexture.f_118083_);
        }
        poseStack.m_85849_();
        super.m_7392_(entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return this.textureMap.get((Object)((AlexsCavesBoat)entity).getACBoatType());
    }
}

