/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.particle.VoidBeingCloudParticle;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class VoidBeingTendrilParticle
extends Particle {
    private static final ResourceLocation TENDRIL_TEXTURE = new ResourceLocation("alexscaves", "textures/particle/void_being_cloud_tendril.png");
    private Vec3 tipTarget;
    private double tipX;
    private double tipY;
    private double tipZ;
    private double prevTipX;
    private double prevTipY;
    private double prevTipZ;
    private float animationOffset = 0.0f;
    private int targetId = -1;
    private float size;
    private int seekByTime = 0;
    private float cameraOffsetX = 0.0f;
    private float cameraOffsetY = 0.0f;

    private VoidBeingTendrilParticle(ClientLevel world, double x, double y, double z, double targetId, double seekByTime) {
        super(world, x, y, z);
        this.m_107250_(1.0f, 1.0f);
        this.f_107226_ = 0.0f;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107225_ = 300;
        this.size = 1.0f;
        this.tipTarget = new Vec3((double)(this.f_107223_.m_188501_() - 0.5f), (double)(this.f_107223_.m_188501_() - 0.5f), (double)(this.f_107223_.m_188501_() - 0.5f)).m_82541_().m_82490_(12.0).m_82520_(x, y, z);
        this.targetId = (int)targetId;
        this.animationOffset = (float)(Math.PI * (double)this.f_107223_.m_188501_());
        this.tipX = x;
        this.tipY = y;
        this.tipZ = z;
        this.cameraOffsetX = (this.f_107223_.m_188501_() - 0.5f) * 1.3f;
        this.cameraOffsetY = (this.f_107223_.m_188501_() - 0.5f) * 1.3f;
        this.seekByTime = (int)seekByTime;
    }

    public void m_5989_() {
        super.m_5989_();
        this.prevTipX = this.tipX;
        this.prevTipY = this.tipY;
        this.prevTipZ = this.tipZ;
        Entity entityTarget = null;
        if (this.targetId != -1 && this.f_107224_ > this.seekByTime) {
            entityTarget = Minecraft.m_91087_().f_91073_.m_6815_(this.targetId);
            if (entityTarget == null) {
                this.targetId = -1;
                this.m_107274_();
            } else {
                this.tipTarget = entityTarget.m_20182_().m_82520_(0.0, 0.25, 0.0);
            }
        }
        if (this.tipTarget != null) {
            float ageSmooth = (float)this.f_107224_ * 0.3f;
            Vec3 tippening = this.tipTarget.m_82492_(this.tipX, this.tipY, this.tipZ);
            if (entityTarget == null) {
                tippening = tippening.m_82520_((double)((float)Math.sin(ageSmooth + this.animationOffset)), (double)((float)Math.cos((double)ageSmooth - 1.5707963267948966 + (double)this.animationOffset)), (double)(-((float)Math.cos(ageSmooth + this.animationOffset))));
            }
            if (tippening.m_82553_() > 1.0) {
                tippening = tippening.m_82541_();
            }
            this.tipX += tippening.f_82479_ * 0.2;
            this.tipY += tippening.f_82480_ * 0.2;
            this.tipZ += tippening.f_82481_ * 0.2;
            if (entityTarget == null && this.f_107223_.m_188501_() < 0.1f) {
                this.tipTarget = new Vec3((double)(this.f_107223_.m_188501_() - 0.5f), (double)(this.f_107223_.m_188501_() - 0.5f), (double)(this.f_107223_.m_188501_() - 0.5f)).m_82541_().m_82490_(12.0).m_82520_(this.f_107212_, this.f_107213_, this.f_107214_);
            }
        }
        this.f_107215_ *= 0.97;
        this.f_107216_ *= 0.97;
        this.f_107217_ *= 0.97;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        Vec3 cameraPos = camera.m_90583_();
        double x = (float)Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_);
        double y = (float)Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_);
        double z = (float)Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_);
        Vector3f cameraOffset = new Vector3f(this.cameraOffsetX, this.cameraOffsetY, -0.1f);
        Quaternionf quaternion = new Quaternionf((Quaternionfc)camera.m_253121_());
        cameraOffset.rotate((Quaternionfc)quaternion);
        float width = this.targetId == -1 ? 1.5f : 1.5f + (float)this.f_107224_ / (float)this.f_107225_;
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer vertexconsumer = multibuffersource$buffersource.m_6299_(ACRenderTypes.m_110467_((ResourceLocation)TENDRIL_TEXTURE));
        PoseStack posestack = new PoseStack();
        posestack.m_85836_();
        posestack.m_85837_(-cameraPos.f_82479_ + x + (double)cameraOffset.x, -cameraPos.f_82480_ + y + (double)cameraOffset.y + (double)(0.2f * (float)Math.sin(((float)this.f_107224_ + partialTick + this.animationOffset) * 0.1f)), -cameraPos.f_82481_ + z + (double)cameraOffset.z);
        int samples = 1;
        Vec3 drawFrom = new Vec3(0.0, 0.0, 0.0);
        Vec3 topAngleVec = new Vec3(0.0, (double)width, 0.0);
        Vec3 bottomAngleVec = new Vec3(0.0, (double)(-width), 0.0);
        int j = this.m_6355_(partialTick);
        float sampleCount = 20.0f;
        while ((float)samples <= sampleCount) {
            float samplesScale = (float)samples / sampleCount;
            float wiggleAmount = (float)Math.sin((double)samplesScale * Math.PI);
            Vec3 drawTo = this.getTendrilPosition(samplesScale, wiggleAmount, new Vec3(cameraOffset), partialTick);
            float u1 = (float)(samples - 1) / sampleCount;
            float u2 = (float)samples / sampleCount;
            float overallAlpha = VoidBeingCloudParticle.getAlphaFromAge(this.f_107224_, this.f_107225_);
            float startA = Math.min(1.0f, (float)samples / (sampleCount - 8.0f)) * overallAlpha;
            float endA = Math.min(1.0f, (float)(samples + 1) / (sampleCount - 8.0f)) * overallAlpha;
            PoseStack.Pose posestack$pose = posestack.m_85850_();
            Matrix4f matrix4f = posestack$pose.m_252922_();
            Matrix3f matrix3f = posestack$pose.m_252943_();
            vertexconsumer.m_252986_(matrix4f, (float)drawFrom.f_82479_ + (float)bottomAngleVec.f_82479_, (float)drawFrom.f_82480_ + (float)bottomAngleVec.f_82480_, (float)drawFrom.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, startA).m_7421_(u1, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)drawTo.f_82479_ + (float)bottomAngleVec.f_82479_, (float)drawTo.f_82480_ + (float)bottomAngleVec.f_82480_, (float)drawTo.f_82481_ + (float)bottomAngleVec.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, endA).m_7421_(u2, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)drawTo.f_82479_ + (float)topAngleVec.f_82479_, (float)drawTo.f_82480_ + (float)topAngleVec.f_82480_, (float)drawTo.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, endA).m_7421_(u2, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, (float)drawFrom.f_82479_ + (float)topAngleVec.f_82479_, (float)drawFrom.f_82480_ + (float)topAngleVec.f_82480_, (float)drawFrom.f_82481_ + (float)topAngleVec.f_82481_).m_85950_(1.0f, 1.0f, 1.0f, startA).m_7421_(u1, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(j).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
            ++samples;
            drawFrom = drawTo;
        }
        multibuffersource$buffersource.m_109911_();
        posestack.m_85849_();
    }

    private Vec3 getTendrilPosition(float f, float wiggleAmount, Vec3 cameraOffset, float partialTick) {
        float x = (float)Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_);
        float y = (float)Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_);
        float z = (float)Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_);
        float ageSmooth = ((float)this.f_107224_ + partialTick) * (this.targetId == -1 || this.f_107224_ < 200 ? 0.04f : 1.0f);
        Vec3 wiggleVec = new Vec3((double)((float)Math.sin(ageSmooth + f + this.animationOffset)), (double)((float)Math.cos((double)ageSmooth - 1.5707963267948966 + (double)f + (double)this.animationOffset)), (double)(-((float)Math.cos(ageSmooth + f + this.animationOffset)))).m_82490_((double)(wiggleAmount * 0.2f));
        Vec3 lerpOf = new Vec3(this.tipX - this.prevTipX, this.tipY - this.prevTipY, this.tipZ - this.prevTipZ).m_82490_((double)partialTick);
        Vec3 vec31 = new Vec3(this.prevTipX, this.prevTipY, this.prevTipZ).m_82549_(lerpOf).m_82546_(cameraOffset);
        return vec31.m_82492_((double)x, (double)y, (double)z).m_82490_((double)f).m_82549_(wiggleVec);
    }

    private Quaternionf calcCameraAngle(Camera camera, float sampleScale) {
        float followCameraAmount = sampleScale * sampleScale;
        return new Quaternionf((Quaternionfc)camera.m_253121_()).rotateX(followCameraAmount * ((float)(-Math.PI) / 180) * camera.m_90589_()).rotateY(followCameraAmount * ((float)Math.PI / 180) * camera.m_90590_());
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new VoidBeingTendrilParticle(worldIn, x, y, z, xSpeed, ySpeed);
        }
    }
}

