/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.particle.AbstractTrailParticle;
import com.github.alexmodguy.alexscaves.server.entity.living.DinosaurEntity;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DinosaurTransformParticle
extends AbstractTrailParticle {
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("alexscaves", "textures/particle/trail.png");
    private int dinosaurId;
    private float lastDinosaurWidth;
    private float initialWidth;
    private float initialYRot;
    private float rotateByAge;
    private float initialOrbitHeight = -1.0f;

    public DinosaurTransformParticle(ClientLevel world, double x, double y, double z, int dinosaurId) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.dinosaurId = dinosaurId;
        this.f_107226_ = 0.0f;
        this.f_107225_ = 20 + this.f_107223_.m_188503_(20);
        this.initialYRot = this.f_107223_.m_188501_() * 360.0f;
        this.rotateByAge = (10.0f + this.f_107223_.m_188501_() * 20.0f) * (this.f_107223_.m_188499_() ? -1.0f : 1.0f);
        Vec3 vec3 = this.getOrbitPosition();
        this.f_107212_ = this.f_107209_ = vec3.f_82479_;
        this.f_107213_ = this.f_107210_ = vec3.f_82480_;
        this.f_107214_ = this.f_107211_ = vec3.f_82481_;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
    }

    public Vec3 getDinosaurPosition() {
        Entity entity;
        if (this.dinosaurId != -1 && (entity = this.f_107208_.m_6815_(this.dinosaurId)) instanceof DinosaurEntity) {
            DinosaurEntity dinosaur = (DinosaurEntity)entity;
            this.lastDinosaurWidth = dinosaur.m_20205_();
            if (this.initialOrbitHeight == -1.0f) {
                this.initialOrbitHeight = this.f_107223_.m_188501_() * dinosaur.m_20206_();
                this.initialWidth = this.lastDinosaurWidth + this.f_107223_.m_188501_();
            }
            return dinosaur.m_20182_();
        }
        return new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    public Vec3 getOrbitPosition() {
        Vec3 dinoPos = this.getDinosaurPosition();
        Vec3 vec3 = new Vec3(0.0, (double)this.initialOrbitHeight, (double)this.initialWidth).m_82524_((float)Math.toRadians(this.initialYRot + this.rotateByAge * (float)this.f_107224_));
        return dinoPos.m_82549_(vec3);
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        float fade = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        this.trailA = 1.0f * fade;
        Vec3 vec3 = this.getOrbitPosition();
        this.f_107212_ = vec3.f_82479_;
        this.f_107213_ = vec3.f_82480_;
        this.f_107214_ = vec3.f_82481_;
    }

    @Override
    public int sampleCount() {
        return 4;
    }

    @Override
    public int sampleStep() {
        return 1;
    }

    @Override
    public float getTrailHeight() {
        return 0.5f;
    }

    public int m_6355_(float f) {
        return 240;
    }

    @Override
    public ResourceLocation getTrailTexture() {
        return TRAIL_TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class TectonicFactory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DinosaurTransformParticle particle = new DinosaurTransformParticle(worldIn, x, y, z, (int)xSpeed);
            particle.trailR = 0.9f + worldIn.f_46441_.m_188501_() * 0.05f;
            particle.trailG = 0.1f;
            particle.trailB = 0.1f;
            return particle;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class AmberFactory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            DinosaurTransformParticle particle = new DinosaurTransformParticle(worldIn, x, y, z, (int)xSpeed);
            particle.trailR = 1.0f;
            particle.trailG = 0.69f + worldIn.f_46441_.m_188501_() * 0.025f;
            particle.trailB = 0.11f + worldIn.f_46441_.m_188501_() * 0.025f;
            return particle;
        }
    }
}

