/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.UnderzealotEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.ModelAnimator;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;

public class UnderzealotModel
extends AdvancedEntityModel<UnderzealotEntity> {
    private final AdvancedModelBox root;
    private final AdvancedModelBox body;
    private final AdvancedModelBox rarm;
    private final AdvancedModelBox larm;
    private final AdvancedModelBox head;
    private final AdvancedModelBox cube_r1;
    private final AdvancedModelBox nose;
    private final AdvancedModelBox rleg;
    private final AdvancedModelBox lleg;
    private final ModelAnimator animator;
    public boolean noBurrowing;

    public UnderzealotModel() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this);
        this.root.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.body = new AdvancedModelBox((AdvancedEntityModel)this);
        this.body.setRotationPoint(0.0f, -8.0f, 1.0f);
        this.root.addChild((BasicModelPart)this.body);
        this.body.setTextureOffset(0, 37).addBox(-6.5f, -7.0f, -5.0f, 13.0f, 11.0f, 10.0f, 0.0f, false);
        this.body.setTextureOffset(0, 0).addBox(-6.5f, -7.0f, -5.0f, 13.0f, 14.0f, 10.0f, 0.25f, false);
        this.rarm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rarm.setRotationPoint(-6.25f, -6.0f, -0.5f);
        this.body.addChild((BasicModelPart)this.rarm);
        this.rarm.setTextureOffset(34, 58).addBox(-2.75f, -1.0f, -2.5f, 2.0f, 9.0f, 5.0f, 0.0f, true);
        this.rarm.setTextureOffset(59, 62).addBox(-2.75f, 8.0f, -2.5f, 2.0f, 3.0f, 5.0f, 0.0f, true);
        this.rarm.setTextureOffset(20, 58).addBox(-2.75f, -1.0f, -2.5f, 2.0f, 9.0f, 5.0f, 0.25f, true);
        this.larm = new AdvancedModelBox((AdvancedEntityModel)this);
        this.larm.setRotationPoint(6.25f, -6.0f, -0.5f);
        this.body.addChild((BasicModelPart)this.larm);
        this.larm.setTextureOffset(34, 58).addBox(0.75f, -1.0f, -2.5f, 2.0f, 9.0f, 5.0f, 0.0f, false);
        this.larm.setTextureOffset(59, 62).addBox(0.75f, 8.0f, -2.5f, 2.0f, 3.0f, 5.0f, 0.0f, false);
        this.larm.setTextureOffset(20, 58).addBox(0.75f, -1.0f, -2.5f, 2.0f, 9.0f, 5.0f, 0.25f, false);
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, -7.0f, -1.0f);
        this.body.addChild((BasicModelPart)this.head);
        this.head.setTextureOffset(42, 14).addBox(-6.5f, -7.25f, -4.0f, 13.0f, 7.0f, 10.0f, 0.24f, false);
        this.head.setTextureOffset(46, 31).addBox(-6.5f, -7.0f, -4.0f, 13.0f, 7.0f, 10.0f, 0.0f, false);
        this.cube_r1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.cube_r1.setRotationPoint(2.99f, -7.49f, 6.24f);
        this.head.addChild((BasicModelPart)this.cube_r1);
        this.setRotateAngle(this.cube_r1, -0.7854f, 0.0f, 0.0f);
        this.cube_r1.setTextureOffset(46, 0).addBox(-6.5f, 0.25f, 0.25f, 7.0f, 4.0f, 7.0f, 0.25f, false);
        this.nose = new AdvancedModelBox((AdvancedEntityModel)this);
        this.nose.setRotationPoint(0.0f, -5.0f, -3.75f);
        this.head.addChild((BasicModelPart)this.nose);
        this.nose.setTextureOffset(42, 31).addBox(-2.5f, -1.0f, -2.25f, 5.0f, 2.0f, 2.0f, 0.0f, false);
        this.nose.setTextureOffset(46, 48).addBox(-7.0f, -5.0f, -1.25f, 14.0f, 11.0f, 0.0f, 0.0f, false);
        this.rleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.rleg.setRotationPoint(-3.5f, -4.0f, 1.0f);
        this.root.addChild((BasicModelPart)this.rleg);
        this.rleg.setTextureOffset(74, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, 0.0f, true);
        this.lleg = new AdvancedModelBox((AdvancedEntityModel)this);
        this.lleg.setRotationPoint(3.5f, -4.0f, 1.0f);
        this.root.addChild((BasicModelPart)this.lleg);
        this.lleg.setTextureOffset(74, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, 0.0f, false);
        this.updateDefaultPose();
        this.animator = ModelAnimator.create();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.body, (Object)this.head, (Object)this.nose, (Object)this.cube_r1, (Object)this.rleg, (Object)this.lleg, (Object)this.rarm, (Object)this.larm);
    }

    public void animate(IAnimatedEntity entity) {
        this.animator.update(entity);
        this.animator.setAnimation(UnderzealotEntity.ANIMATION_ATTACK_0);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.body, (float)Math.toRadians(30.0), 0.0f, 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(-100.0), 0.0f, (float)Math.toRadians(-40.0));
        this.animator.rotate(this.larm, (float)Math.toRadians(-100.0), 0.0f, (float)Math.toRadians(40.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.body, (float)Math.toRadians(-30.0), 0.0f, 0.0f);
        this.animator.rotate(this.head, (float)Math.toRadians(-30.0), 0.0f, 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(-145.0), (float)Math.toRadians(40.0), (float)Math.toRadians(10.0));
        this.animator.rotate(this.larm, (float)Math.toRadians(-145.0), (float)Math.toRadians(-40.0), (float)Math.toRadians(-10.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(UnderzealotEntity.ANIMATION_ATTACK_1);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.body, (float)Math.toRadians(-10.0), (float)Math.toRadians(30.0), 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(-70.0), (float)Math.toRadians(70.0), (float)Math.toRadians(-10.0));
        this.animator.rotate(this.larm, (float)Math.toRadians(-90.0), (float)Math.toRadians(-30.0), (float)Math.toRadians(10.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.body, (float)Math.toRadians(-10.0), (float)Math.toRadians(-60.0), 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(-90.0), (float)Math.toRadians(30.0), (float)Math.toRadians(10.0));
        this.animator.rotate(this.larm, (float)Math.toRadians(-70.0), (float)Math.toRadians(-20.0), (float)Math.toRadians(-10.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
        this.animator.setAnimation(UnderzealotEntity.ANIMATION_BREAKTORCH);
        this.animator.startKeyframe(5);
        this.animator.rotate(this.body, (float)Math.toRadians(10.0), (float)Math.toRadians(-20.0), 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(-30.0), (float)Math.toRadians(10.0), (float)Math.toRadians(-10.0));
        this.animator.endKeyframe();
        this.animator.startKeyframe(5);
        this.animator.rotate(this.body, (float)Math.toRadians(-5.0), 0.0f, 0.0f);
        this.animator.rotate(this.rarm, (float)Math.toRadians(-150.0), (float)Math.toRadians(10.0), (float)Math.toRadians(-10.0));
        this.animator.endKeyframe();
        this.animator.resetKeyframe(5);
    }

    public void setupAnim(UnderzealotEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        this.animate(entity);
        float partialTick = ageInTicks - (float)entity.f_19797_;
        float buriedProgress = this.noBurrowing ? 0.0f : entity.getBuriedProgress(partialTick);
        float carryingProgress = entity.getCarryingProgress(partialTick);
        float prayingProgress = entity.getPrayingProgress(partialTick);
        float buriedStrength = (float)Math.sin((double)buriedProgress * Math.PI);
        float walkSpeed = 0.5f;
        float walkDegree = 1.0f;
        float digSpeed = 0.9f;
        float digDegree = 1.0f;
        float praySpeed = 0.2f;
        float prayDegree = 1.0f;
        float armFreedom = 1.0f - carryingProgress;
        this.progressPositionPrev(this.root, buriedProgress, 0.0f, 28.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.rarm, buriedProgress, -2.0f, -1.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.larm, buriedProgress, 2.0f, -1.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.rarm, carryingProgress, 0.0f, -2.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.larm, carryingProgress, 0.0f, -2.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rarm, buriedProgress, 0.0f, 0.0f, (float)Math.toRadians(160.0), 1.0f);
        this.progressRotationPrev(this.larm, buriedProgress, 0.0f, 0.0f, (float)Math.toRadians(-160.0), 1.0f);
        this.progressRotationPrev(this.rarm, carryingProgress, (float)Math.toRadians(-180.0), 0.0f, (float)Math.toRadians(20.0), 1.0f);
        this.progressRotationPrev(this.larm, carryingProgress, (float)Math.toRadians(-180.0), 0.0f, (float)Math.toRadians(-20.0), 1.0f);
        this.walk(this.nose, 0.4f, 0.1f, false, 1.0f, -0.05f, ageInTicks, 1.0f);
        this.swing(this.nose, 0.3f, 0.1f, false, 3.0f, 0.0f, ageInTicks, 1.0f);
        this.flap(this.rarm, 0.1f, 0.05f, false, 4.0f, 0.05f, ageInTicks, 1.0f);
        this.flap(this.larm, 0.1f, 0.05f, true, 4.0f, 0.05f, ageInTicks, 1.0f);
        this.swing(this.body, walkSpeed, walkDegree * 0.1f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.swing(this.head, walkSpeed, walkDegree * 0.1f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.lleg, walkSpeed, walkDegree * 0.5f, false, 1.0f, -0.2f, limbSwing, limbSwingAmount);
        this.walk(this.rleg, walkSpeed, walkDegree * 0.5f, true, 1.0f, 0.2f, limbSwing, limbSwingAmount);
        this.lleg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, -0.5f, 2.0f, true));
        this.rleg.rotationPointY += Math.min(0.0f, ACMath.walkValue(limbSwing, limbSwingAmount, walkSpeed, -0.5f, 2.0f, false));
        this.flap(this.rarm, walkSpeed, walkDegree * 0.1f, false, 4.0f, 0.25f, limbSwing, limbSwingAmount * armFreedom);
        this.flap(this.larm, walkSpeed, walkDegree * 0.1f, true, 4.0f, 0.25f, limbSwing, limbSwingAmount * armFreedom);
        this.swing(this.root, digSpeed, digDegree * 0.1f, false, 2.0f, 0.0f, ageInTicks, buriedStrength);
        this.walk(this.rarm, digSpeed, digDegree, false, 4.0f, 0.0f, ageInTicks, buriedStrength);
        this.walk(this.larm, digSpeed, digDegree, true, 4.0f, 0.0f, ageInTicks, buriedStrength);
        this.walk(this.head, digSpeed, digDegree * 0.1f, true, 4.0f, 0.5f, ageInTicks, buriedStrength);
        this.progressPositionPrev(this.root, prayingProgress, 0.0f, -2.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.body, prayingProgress, 0.0f, 0.0f, 2.0f, 1.0f);
        this.progressRotationPrev(this.root, prayingProgress, (float)Math.toRadians(-30.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.lleg, prayingProgress, 0.0f, 4.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.lleg, prayingProgress, (float)Math.toRadians(120.0), 0.0f, 0.0f, 1.0f);
        this.progressPositionPrev(this.rleg, prayingProgress, 0.0f, 4.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rleg, prayingProgress, (float)Math.toRadians(120.0), 0.0f, 0.0f, 1.0f);
        this.progressRotationPrev(this.rarm, prayingProgress * armFreedom, (float)Math.toRadians(-160.0), (float)Math.toRadians(60.0), 0.0f, 1.0f);
        this.progressRotationPrev(this.larm, prayingProgress * armFreedom, (float)Math.toRadians(-160.0), (float)Math.toRadians(-60.0), 0.0f, 1.0f);
        float bodyForwards = -Math.max(0.0f, ACMath.walkValue(ageInTicks, prayingProgress, praySpeed, 4.0f, 6.0f, false));
        this.body.rotationPointY -= bodyForwards * 0.5f;
        this.body.rotationPointZ += bodyForwards;
        this.walk(this.body, praySpeed, prayDegree * 0.5f, false, 4.0f, 0.4f, ageInTicks, prayingProgress);
        this.walk(this.head, praySpeed, prayDegree * 0.5f, false, 3.0f, 0.1f, ageInTicks, prayingProgress);
        this.walk(this.larm, praySpeed, prayDegree, false, 4.0f, 1.0f, ageInTicks, prayingProgress * armFreedom);
        this.swing(this.larm, praySpeed, prayDegree, false, 4.0f, 0.2f, ageInTicks, prayingProgress * armFreedom);
        this.walk(this.rarm, praySpeed, prayDegree, false, 4.0f, 1.0f, ageInTicks, prayingProgress * armFreedom);
        this.swing(this.rarm, praySpeed, prayDegree, true, 4.0f, 0.2f, ageInTicks, prayingProgress * armFreedom);
        this.faceTarget(netHeadYaw, headPitch, 1.0f, new AdvancedModelBox[]{this.head});
    }
}

