/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.BoundroidEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;

public class BoundroidModel
extends AdvancedEntityModel<BoundroidEntity> {
    private final AdvancedModelBox head;
    private final AdvancedModelBox bump1;
    private final AdvancedModelBox bump2;

    public BoundroidModel() {
        this.texWidth = 128;
        this.texHeight = 128;
        this.head = new AdvancedModelBox((AdvancedEntityModel)this);
        this.head.setRotationPoint(0.0f, 13.0f, 0.0f);
        this.head.setTextureOffset(0, 27).addBox(-6.0f, 1.0f, -6.0f, 12.0f, 5.0f, 12.0f, 0.0f, false);
        this.head.setTextureOffset(0, 0).addBox(-11.0f, 6.0f, -11.0f, 22.0f, 5.0f, 22.0f, 0.0f, false);
        this.bump1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.bump1.setRotationPoint(0.0f, -1.5f, 0.0f);
        this.head.addChild((BasicModelPart)this.bump1);
        this.setRotateAngle(this.bump1, 0.0f, -0.7854f, 0.0f);
        this.bump1.setTextureOffset(0, 0).addBox(-4.0f, -2.5f, 0.0f, 8.0f, 5.0f, 0.0f, 0.0f, false);
        this.bump2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.bump2.setRotationPoint(0.0f, -1.5f, 0.0f);
        this.head.addChild((BasicModelPart)this.bump2);
        this.setRotateAngle(this.bump2, 0.0f, 0.7854f, 0.0f);
        this.bump2.setTextureOffset(0, 0).addBox(-4.0f, -2.5f, 0.0f, 8.0f, 5.0f, 0.0f, 0.0f, false);
        this.updateDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.head);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.head, (Object)this.bump2, (Object)this.bump1);
    }

    public void showChains() {
        this.bump1.showModel = true;
        this.bump2.showModel = true;
    }

    public void hideChains() {
        this.bump1.showModel = false;
        this.bump2.showModel = false;
    }

    public void setupAnim(BoundroidEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float offGroundAmount = 1.0f - entity.getGroundProgress(ageInTicks - (float)entity.f_19797_);
        float yawAmount = netHeadYaw / 57.295776f;
        this.head.rotateAngleY += yawAmount;
        this.walk(this.head, 0.15f, 0.2f, false, -1.0f, 0.0f, ageInTicks, offGroundAmount);
        this.flap(this.head, 0.15f, 0.2f, false, 1.0f, 0.0f, ageInTicks, offGroundAmount);
    }

    public void animateForQuarry(float ageInTicks, float slamAmount) {
        this.resetToDefaultPose();
        float offGroundAmount = 1.0f - slamAmount;
        this.walk(this.head, 0.15f, 0.2f, false, -1.0f, 0.0f, ageInTicks, offGroundAmount);
        this.flap(this.head, 0.15f, 0.2f, false, 1.0f, 0.0f, ageInTicks, offGroundAmount);
    }
}

