/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.util;

import de.cadentem.quality_food.core.Quality;
import de.cadentem.quality_food.registry.QFItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class OverlayUtils {
    private static ItemStack IRON_OVERLAY;
    private static ItemStack GOLD_OVERLAY;
    private static ItemStack DIAMOND_OVERLAY;

    public static ItemStack getOverlay(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            CompoundTag qualityTag = tag.m_128469_("quality_food");
            return OverlayUtils.getOverlay(qualityTag.m_128451_("quality"));
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getOverlay(int ordinal) {
        return OverlayUtils.getOverlay(Quality.get(ordinal));
    }

    public static ItemStack getOverlay(Quality quality) {
        return switch (quality) {
            case Quality.IRON -> {
                if (IRON_OVERLAY == null) {
                    IRON_OVERLAY = new ItemStack((ItemLike)QFItems.IRON_OVERLAY.get());
                }
                yield IRON_OVERLAY;
            }
            case Quality.GOLD -> {
                if (GOLD_OVERLAY == null) {
                    GOLD_OVERLAY = new ItemStack((ItemLike)QFItems.GOLD_OVERLAY.get());
                }
                yield GOLD_OVERLAY;
            }
            case Quality.DIAMOND -> {
                if (DIAMOND_OVERLAY == null) {
                    DIAMOND_OVERLAY = new ItemStack((ItemLike)QFItems.DIAMOND_OVERLAY.get());
                }
                yield DIAMOND_OVERLAY;
            }
            default -> ItemStack.f_41583_;
        };
    }

    public static boolean isOverlay(ItemStack stack) {
        return stack == IRON_OVERLAY || stack == GOLD_OVERLAY || stack == DIAMOND_OVERLAY;
    }
}

