/*
 * Decompiled with CFR 0.152.
 */
package de.cadentem.quality_food.capability;

import de.cadentem.quality_food.capability.LevelDataProvider;
import de.cadentem.quality_food.core.Quality;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LevelData {
    private final HashMap<Long, Quality> qualities = new HashMap();
    @Nullable
    private Quality lastRemoved;

    @NotNull
    public Quality get(BlockPos position) {
        Quality quality = this.qualities.get(position.m_121878_());
        if (quality == null) {
            return Quality.NONE;
        }
        return quality;
    }

    public void set(BlockPos position, Quality quality) {
        if (quality == Quality.NONE) {
            this.remove(position);
            return;
        }
        this.qualities.put(position.m_121878_(), quality);
    }

    public void remove(BlockPos position) {
        this.lastRemoved = this.qualities.remove(position.m_121878_());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (Long key : this.qualities.keySet()) {
            tag.m_128405_(String.valueOf(key), this.qualities.get(key).ordinal());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.qualities.clear();
        tag.m_128431_().forEach(key -> {
            Quality quality = Quality.get(tag.m_128451_(String.valueOf(key)), true);
            this.qualities.put(Long.parseLong(key), quality);
        });
    }

    public static void set(LevelAccessor level, BlockPos position, Quality quality) {
        if (quality != Quality.NONE) {
            LevelDataProvider.getCapability(level).ifPresent(data -> data.set(position, quality));
        }
    }

    @NotNull
    public static Quality get(LevelAccessor level, @Nullable BlockPos position, boolean queryLastRemoved) {
        LevelData data = LevelDataProvider.getOrNull(level);
        if (data == null || position == null) {
            return Quality.NONE;
        }
        Quality result = data.get(position);
        if (queryLastRemoved && data.lastRemoved != null && result == Quality.NONE) {
            result = data.lastRemoved;
            data.lastRemoved = null;
        }
        return result;
    }

    @NotNull
    public static Quality get(LevelAccessor level, BlockPos position) {
        return LevelData.get(level, position, false);
    }
}

