/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.jearchaeology.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.jearchaeology.JEArchaeology;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class SniffRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    public final Ingredient item;
    public final double chance;

    public SniffRecipe(ResourceLocation id, Ingredient item, double chance) {
        this.id = id;
        this.item = item;
        this.chance = chance;
    }

    public boolean m_5818_(Container inv, Level levelIn) {
        return false;
    }

    @Nonnull
    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)JEArchaeology.SNIFF.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)JEArchaeology.SNIFF_TYPE.get();
    }

    public static class Serializer<T extends SniffRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            Ingredient item = Ingredient.m_43917_((JsonElement)json.get("item"));
            double chance = GsonHelper.m_144742_((JsonObject)json, (String)"chance", (double)0.05);
            return this.factory.create(id, item, chance);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            try {
                return this.factory.create(id, Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.readDouble());
            }
            catch (Exception e) {
                JEArchaeology.LOGGER.error("Error reading sniff recipe from packet. " + id, (Throwable)e);
                throw e;
            }
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            try {
                ((SniffRecipe)recipe).item.m_43923_(buffer);
                buffer.writeDouble(((SniffRecipe)recipe).chance);
            }
            catch (Exception e) {
                JEArchaeology.LOGGER.error("Error writing sniff recipe to packet. " + ((SniffRecipe)recipe).m_6423_(), (Throwable)e);
                throw e;
            }
        }

        public static interface IRecipeFactory<T extends SniffRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, double var3);
        }
    }
}

