/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.network.clientbound;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import umpaz.brewinandchewin.common.capability.TipsyNumbedHeartsCapability;

public record SyncNumbedHeartsClientboundPacket(int entityId, float numbedHealth, int ticksUntilDamage) {
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId());
        buf.writeFloat(this.numbedHealth());
        buf.writeInt(this.ticksUntilDamage());
    }

    public static SyncNumbedHeartsClientboundPacket decode(FriendlyByteBuf buf) {
        return new SyncNumbedHeartsClientboundPacket(buf.readInt(), buf.readFloat(), buf.readInt());
    }

    public static class Handler {
        public static void handle(SyncNumbedHeartsClientboundPacket packet, Supplier<NetworkEvent.Context> context) {
            if (context.get().getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
                return;
            }
            context.get().enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityId());
                if (!(entity instanceof LivingEntity)) {
                    return;
                }
                LivingEntity living = (LivingEntity)entity;
                living.getCapability(TipsyNumbedHeartsCapability.INSTANCE).ifPresent(cap -> {
                    cap.setNumbedHealth(packet.numbedHealth());
                    cap.setTicksUntilDamage(packet.ticksUntilDamage());
                });
            });
            context.get().setPacketHandled(true);
        }
    }
}

