/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.common.registry.BnCRecipeSerializers;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.KegRecipeWrapper;

public class KegPouringRecipe
implements Recipe<KegRecipeWrapper> {
    private final ResourceLocation id;
    private final Fluid fluid;
    private final int amount;
    private final Optional<ItemStack> container;
    private final ItemStack output;
    private final boolean strict;
    private final boolean filling;

    public KegPouringRecipe(ResourceLocation id, Fluid fluid, Optional<ItemStack> container, ItemStack output, int amount, boolean strict, boolean filling) {
        this.id = id;
        this.amount = amount;
        this.fluid = fluid;
        this.container = container;
        this.output = output;
        this.strict = strict;
        this.filling = filling;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredient = NonNullList.m_122779_();
        ingredient.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.getContainer()}));
        return ingredient;
    }

    public boolean matches(KegRecipeWrapper inv, Level level) {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.getContainer()}).test(inv.m_8020_(4));
    }

    public ItemStack assemble(KegRecipeWrapper recipeWrapper, RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getContainer() {
        return this.container.orElse(this.output.getCraftingRemainingItem());
    }

    public ItemStack getContainer(ItemStack stack) {
        return this.container.orElse(stack.getCraftingRemainingItem());
    }

    public Optional<ItemStack> getRawContainer() {
        return this.container;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output;
    }

    public int getAmount() {
        return this.amount;
    }

    public FluidStack getFluid(ItemStack container) {
        return new FluidStack(this.fluid, this.amount);
    }

    public Fluid getRawFluid() {
        return this.fluid;
    }

    public boolean hasSpecialFluid() {
        return false;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean canFill() {
        return this.filling;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)BnCRecipeSerializers.KEG_POURING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)BnCRecipeTypes.KEG_POURING.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)BnCItems.KEG.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.fluid, this.amount, this.container, this.output, this.strict, this.filling);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KegPouringRecipe that = (KegPouringRecipe)o;
        if (!this.m_6423_().equals((Object)that.m_6423_())) {
            return false;
        }
        if (!this.output.equals(that.output)) {
            return false;
        }
        if (this.amount != that.amount) {
            return false;
        }
        if (!this.fluid.equals(that.fluid)) {
            return false;
        }
        if (!this.container.equals(that.container)) {
            return false;
        }
        if (this.strict != that.strict) {
            return false;
        }
        return this.filling == that.filling;
    }

    public static class Serializer
    implements RecipeSerializer<KegPouringRecipe> {
        public KegPouringRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Fluid fluidIn = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid")));
            int amountIn = GsonHelper.m_13824_((JsonObject)json, (String)"amount", (int)250);
            Optional<ItemStack> container = GsonHelper.m_13900_((JsonObject)json, (String)"container") ? Optional.of(CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"container"), (boolean)true)) : Optional.empty();
            ItemStack outputIn = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"), (boolean)true);
            boolean strictIn = GsonHelper.m_13855_((JsonObject)json, (String)"strict", (boolean)false);
            boolean fillingIn = GsonHelper.m_13855_((JsonObject)json, (String)"filling", (boolean)true);
            if (!outputIn.hasCraftingRemainingItem() && container.isEmpty()) {
                throw new JsonParseException("\"container\" field must be specified if the output doesn't have a crafting remainder item.");
            }
            return new KegPouringRecipe(recipeId, fluidIn, container, outputIn, amountIn, strictIn, fillingIn);
        }

        @Nullable
        public KegPouringRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Fluid fluidIn = buffer.readFluidStack().getFluid();
            int amountIn = buffer.m_130242_();
            Optional containerIn = buffer.m_236860_(FriendlyByteBuf::m_130267_);
            ItemStack outputIn = buffer.m_130267_();
            boolean strictIn = buffer.readBoolean();
            boolean fillingIn = buffer.readBoolean();
            return new KegPouringRecipe(recipeId, fluidIn, containerIn, outputIn, amountIn, strictIn, fillingIn);
        }

        public void toNetwork(FriendlyByteBuf buffer, KegPouringRecipe recipe) {
            buffer.writeFluidStack(new FluidStack(recipe.fluid, 1000));
            buffer.m_130130_(recipe.amount);
            buffer.m_236835_(recipe.container, FriendlyByteBuf::m_130055_);
            buffer.m_130055_(recipe.output);
            buffer.writeBoolean(recipe.strict);
            buffer.writeBoolean(recipe.filling);
        }
    }
}

