/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.api.layered;

import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.core.util.Vec3f;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class PlayerAnimationFrame
implements IAnimation {
    protected PlayerPart head = new PlayerPart();
    protected PlayerPart body = new PlayerPart();
    protected PlayerPart rightArm = new PlayerPart();
    protected PlayerPart leftArm = new PlayerPart();
    protected PlayerPart rightLeg = new PlayerPart();
    protected PlayerPart leftLeg = new PlayerPart();
    protected PlayerPart rightItem = new PlayerPart();
    protected PlayerPart leftItem = new PlayerPart();
    HashMap<String, PlayerPart> parts = new HashMap();

    public PlayerAnimationFrame() {
        this.parts.put("head", this.head);
        this.parts.put("body", this.body);
        this.parts.put("rightArm", this.rightArm);
        this.parts.put("leftArm", this.leftArm);
        this.parts.put("rightLeg", this.rightLeg);
        this.parts.put("leftLeg", this.leftLeg);
        this.parts.put("rightItem", this.rightItem);
        this.parts.put("leftItem", this.leftItem);
    }

    @Override
    public void tick() {
        IAnimation.super.tick();
    }

    @Override
    public boolean isActive() {
        for (Map.Entry<String, PlayerPart> entry : this.parts.entrySet()) {
            PlayerPart part = entry.getValue();
            if (part.bend == null && part.pos == null && part.rot == null) continue;
            return true;
        }
        return false;
    }

    public void resetPose() {
        for (Map.Entry<String, PlayerPart> entry : this.parts.entrySet()) {
            entry.getValue().setNull();
        }
    }

    @Override
    @NotNull
    public Vec3f get3DTransform(@NotNull String modelName, @NotNull TransformType type, float tickDelta, @NotNull Vec3f value0) {
        PlayerPart part = this.parts.get(modelName);
        if (part == null) {
            return value0;
        }
        switch (type) {
            case POSITION: {
                return part.pos == null ? value0 : part.pos;
            }
            case ROTATION: {
                return part.rot == null ? value0 : part.rot;
            }
            case BEND: {
                return part.bend == null ? value0 : new Vec3f(part.bend.getLeft().floatValue(), part.bend.getRight().floatValue(), 0.0f);
            }
        }
        return value0;
    }

    public static class PlayerPart {
        public Vec3f pos;
        public Vec3f rot;
        public Pair<Float, Float> bend;

        protected void setNull() {
            this.rot = null;
            this.pos = null;
            this.bend = null;
        }
    }
}

