/*
 * Decompiled with CFR 0.152.
 */
package com.sswltzz.tetracompat.mixin.ftbultimine;

import com.google.common.collect.BiMap;
import dev.ftb.mods.ftbultimine.BrokenItemHandler;
import dev.ftb.mods.ftbultimine.FTBUltiminePlayerData;
import dev.ftb.mods.ftbultimine.RightClickHandlers;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.properties.IToolProvider;

@Mixin(value={RightClickHandlers.class})
public class RightClickHandlersMixin {
    @Inject(method={"axeStripping"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void axeStrippingMixin(ServerPlayer player, InteractionHand hand, BlockPos clickPos, FTBUltiminePlayerData data, CallbackInfoReturnable<Integer> cir) {
        HashSet<SoundEvent> sounds = new HashSet<SoundEvent>();
        BrokenItemHandler brokenItemHandler = new BrokenItemHandler();
        Level level = player.m_9236_();
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (item instanceof IToolProvider) {
            IToolProvider toolProvider = (IToolProvider)item;
            ToolData toolData = toolProvider.getToolData(itemStack);
            List<ToolAction> tools = toolData.getValues().stream().filter(tool -> toolData.getLevel(tool) > 0).filter(tool -> ToolActions.AXE_STRIP.equals(tool) || ToolActions.AXE_SCRAPE.equals(tool) || ToolActions.AXE_WAX_OFF.equals(tool)).toList();
            boolean strip = tools.contains(ToolActions.AXE_STRIP);
            boolean scrape = tools.contains(ToolActions.AXE_SCRAPE);
            boolean waxOff = tools.contains(ToolActions.AXE_WAX_OFF);
            for (BlockPos pos : data.cachedPositions()) {
                BlockState state = player.m_9236_().m_8055_(pos);
                Optional<BlockState> stripping = Optional.ofNullable(AxeItem.getAxeStrippingState((BlockState)state));
                Optional<BlockState> scraping = WeatheringCopper.m_154899_((BlockState)state);
                Optional<BlockState> waxing = Optional.ofNullable((Block)((BiMap)HoneycombItem.f_150864_.get()).get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
                Optional<BlockState> actual = Optional.empty();
                if (stripping.isPresent() && strip) {
                    sounds.add(SoundEvents.f_11688_);
                    actual = stripping;
                } else if (scraping.isPresent() && scrape) {
                    sounds.add(SoundEvents.f_144059_);
                    level.m_5898_((Player)player, 3005, pos, 0);
                    actual = scraping;
                } else if (waxing.isPresent() && waxOff) {
                    sounds.add(SoundEvents.f_144060_);
                    level.m_5898_((Player)player, 3004, pos, 0);
                    actual = waxing;
                }
                if (!actual.isPresent()) continue;
                CriteriaTriggers.f_10562_.m_285767_(player, pos, itemStack);
                level.m_7731_(pos, (BlockState)actual.get(), 11);
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)player, (BlockState)actual.get()));
                itemStack.m_41622_(1, (LivingEntity)player, (Consumer)brokenItemHandler);
                if (!brokenItemHandler.isBroken) continue;
                break;
            }
            sounds.forEach(sound -> level.m_5594_(null, clickPos, sound, SoundSource.BLOCKS, 1.0f, 1.0f));
            cir.setReturnValue((Object)sounds.size());
        }
    }
}

