/*
 * Decompiled with CFR 0.152.
 */
package com.sswltzz.tetracompat.mixin.alexscaves;

import com.github.alexmodguy.alexscaves.server.enchantment.ACEnchantmentRegistry;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import com.github.alexmodguy.alexscaves.server.entity.item.MagneticWeaponEntity;
import com.github.alexmodguy.alexscaves.server.item.GalenaGauntletItem;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import se.mickelus.tetra.items.modular.ModularItem;

@Mixin(value={GalenaGauntletItem.class})
public class GalenaGauntletItemMixin {
    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    public void useMixin(Level level, Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        ItemStack itemstack = player.m_21120_(interactionHand);
        ItemStack otherHand = interactionHand == InteractionHand.MAIN_HAND ? player.m_21120_(InteractionHand.OFF_HAND) : player.m_21120_(InteractionHand.MAIN_HAND);
        Item item = otherHand.m_41720_();
        if (item instanceof ModularItem) {
            ModularItem modularItem = (ModularItem)item;
            boolean crystallization = itemstack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.CRYSTALLIZATION.get()) > 0;
            boolean magnetizable = modularItem.getEffects(otherHand).stream().anyMatch(itemEffect -> itemEffect.getKey().equals("tetracompat:magnetizable"));
            boolean crystal = modularItem.getEffects(otherHand).stream().anyMatch(itemEffect -> itemEffect.getKey().equals("tetracompat:crystal_magnetizable"));
            if (magnetizable || crystallization && crystal) {
                if (!player.m_7500_()) {
                    itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(player1.m_7655_()));
                }
                player.m_6672_(interactionHand);
                cir.setReturnValue((Object)InteractionResultHolder.m_19096_((Object)itemstack));
            } else {
                cir.setReturnValue((Object)InteractionResultHolder.m_19100_((Object)itemstack));
            }
        }
    }

    @Inject(method={"onUseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getEnchantmentLevel(Lnet/minecraft/world/item/enchantment/Enchantment;)I", shift=At.Shift.AFTER)})
    public void useTickMixin(Level level, LivingEntity living, ItemStack stack, int timeUsing, CallbackInfo ci, @Local InteractionHand otherHand) {
        ItemStack otherStack = living.m_21120_(otherHand);
        boolean otherMagneticWeaponsInUse = false;
        Item item = otherStack.m_41720_();
        if (item instanceof ModularItem) {
            ModularItem modularItem = (ModularItem)item;
            boolean crystallization = stack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.CRYSTALLIZATION.get()) > 0;
            boolean magnetizable = modularItem.getEffects(otherStack).stream().anyMatch(itemEffect -> itemEffect.getKey().equals("tetracompat:magnetizable"));
            boolean crystal = modularItem.getEffects(otherStack).stream().anyMatch(itemEffect -> itemEffect.getKey().equals("tetracompat:crystal_magnetizable"));
            if (magnetizable || crystallization && crystal) {
                for (MagneticWeaponEntity magneticWeapon : level.m_45976_(MagneticWeaponEntity.class, living.m_20191_().m_82377_(64.0, 64.0, 64.0))) {
                    Entity controller = magneticWeapon.getController();
                    if (controller == null || !controller.m_7306_((Entity)living)) continue;
                    otherMagneticWeaponsInUse = true;
                    break;
                }
                if (!otherMagneticWeaponsInUse) {
                    MagneticWeaponEntity magneticWeapon;
                    ItemStack copy = otherStack.m_41777_();
                    otherStack.m_41764_(0);
                    magneticWeapon = (MagneticWeaponEntity)((EntityType)ACEntityRegistry.MAGNETIC_WEAPON.get()).m_20615_(level);
                    magneticWeapon.setItemStack(copy);
                    magneticWeapon.m_146884_(living.m_20182_().m_82520_(0.0, 1.0, 0.0));
                    magneticWeapon.setControllerUUID(living.m_20148_());
                    level.m_7967_((Entity)magneticWeapon);
                }
            } else if (!otherStack.m_41619_()) {
                living.m_5810_();
            }
        }
    }
}

