/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.forge.platform;

import io.github.flemmli97.improvedmobs.difficulty.DifficultyData;
import io.github.flemmli97.improvedmobs.difficulty.PlayerDifficulty;
import io.github.flemmli97.improvedmobs.forge.capability.CapabilityProvider;
import io.github.flemmli97.improvedmobs.forge.network.PacketHandler;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.improvedmobs.utils.ContainerOpened;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fml.loading.FMLPaths;

public class CrossPlatformStuffImpl
implements CrossPlatformStuff {
    @Override
    public void onPlayerOpen(BlockEntity blockEntity) {
        blockEntity.getCapability(CapabilityProvider.CAP).ifPresent(cap -> cap.setOpened(blockEntity));
    }

    @Override
    public boolean canLoot(BlockEntity blockEntity) {
        if (blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
            return blockEntity.getCapability(CapabilityProvider.CAP).map(ContainerOpened::playerOpened).orElse(false) != false && blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).map(cap -> {
                for (int i = 0; i < cap.getSlots(); ++i) {
                    if (cap.getStackInSlot(i).m_41619_()) continue;
                    return true;
                }
                return false;
            }).orElse(false) != false;
        }
        return false;
    }

    @Override
    public ItemStack lootRandomItem(BlockEntity blockEntity, RandomSource rand) {
        return blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).map(cap -> {
            ItemStack drop = cap.extractItem(rand.m_188503_(cap.getSlots()), 1, false);
            for (int tries = 0; drop.m_41619_() && tries < 10; ++tries) {
                drop = cap.extractItem(rand.m_188503_(cap.getSlots()), 1, false);
            }
            return drop;
        }).orElse(ItemStack.f_41583_);
    }

    @Override
    public boolean isLadder(BlockState state, LivingEntity entity, BlockPos pos) {
        return state.isLadder((LevelReader)entity.m_9236_(), pos, entity);
    }

    @Override
    public SoundType blockSound(BlockState state, LivingEntity entity, BlockPos pos) {
        return state.getSoundType((LevelReader)entity.m_9236_(), pos, (Entity)entity);
    }

    @Override
    public void sendDifficultyDataTo(ServerPlayer player, MinecraftServer server) {
        PacketHandler.sendDifficultyToClient(DifficultyData.get(player.m_20194_()), player);
    }

    @Override
    public void sendDifficultyData(DifficultyData data, MinecraftServer server) {
        PacketHandler.sendDifficultyToAll(data, server);
    }

    @Override
    public void sendConfigSync(ServerPlayer player) {
        PacketHandler.sendConfigSync(player);
    }

    @Override
    public Path configDirPath() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public AbstractArrow customBowArrow(BowItem item, AbstractArrow def) {
        return item.customArrow(def);
    }

    @Override
    public boolean canDisableShield(ItemStack attackingStack, ItemStack held, LivingEntity entity, LivingEntity attacker) {
        return attackingStack.canDisableShield(held, entity, attacker);
    }

    @Override
    public Optional<PlayerDifficulty> getPlayerDifficultyData(ServerPlayer player) {
        return player.getCapability(CapabilityProvider.PLAYER_CAP).resolve();
    }
}

