/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.events;

import io.github.flemmli97.improvedmobs.ImprovedMobs;
import io.github.flemmli97.improvedmobs.ai.BlockBreakGoal;
import io.github.flemmli97.improvedmobs.ai.FlyRidingGoal;
import io.github.flemmli97.improvedmobs.ai.ItemUseGoal;
import io.github.flemmli97.improvedmobs.ai.LadderClimbGoal;
import io.github.flemmli97.improvedmobs.ai.StealGoal;
import io.github.flemmli97.improvedmobs.ai.WaterRidingGoal;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.config.DifficultyConfig;
import io.github.flemmli97.improvedmobs.config.EntityModifyFlagConfig;
import io.github.flemmli97.improvedmobs.difficulty.DifficultyData;
import io.github.flemmli97.improvedmobs.entities.RiddenSummonEntity;
import io.github.flemmli97.improvedmobs.mixin.MobEntityMixin;
import io.github.flemmli97.improvedmobs.mixin.NearestTargetGoalMixin;
import io.github.flemmli97.improvedmobs.mixin.TargetGoalAccessor;
import io.github.flemmli97.improvedmobs.mixinhelper.INodeBreakable;
import io.github.flemmli97.improvedmobs.mixinhelper.ISpawnReason;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.improvedmobs.utils.BlockRestorationData;
import io.github.flemmli97.improvedmobs.utils.EntityFlags;
import io.github.flemmli97.improvedmobs.utils.Utils;
import io.github.flemmli97.tenshilib.platform.PlatformUtils;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class EventCalls {
    public static void worldJoin(ServerPlayer player, MinecraftServer server) {
        CrossPlatformStuff.INSTANCE.sendDifficultyDataTo(player, server);
        CrossPlatformStuff.INSTANCE.sendConfigSync(player);
    }

    public static void tick(ServerLevel level) {
        BlockRestorationData.get(level).tick(level);
        if (!Config.CommonConfig.enableDifficultyScaling) {
            return;
        }
        if (!Config.CommonConfig.difficultyType.increaseDifficulty) {
            if (level.m_46467_() % 20L == 0L && level.m_46472_() == Level.f_46428_) {
                CrossPlatformStuff.INSTANCE.sendDifficultyData(DifficultyData.get(level.m_7654_()), level.m_7654_());
            }
            return;
        }
        if (level.m_46472_() == Level.f_46428_) {
            boolean shouldIncrease = (Config.CommonConfig.ignorePlayers || !level.m_7654_().m_6846_().m_11314_().isEmpty()) && level.m_46468_() > (long)Config.CommonConfig.difficultyDelay;
            DifficultyData data = DifficultyData.get(level.m_7654_());
            if (Config.CommonConfig.shouldPunishTimeSkip) {
                long timeDiff = Math.abs(level.m_46468_() - data.getPrevTime());
                if (timeDiff > 2400L) {
                    long i = timeDiff / 2400L;
                    if (timeDiff - i * 2400L > (i + 1L) * 2400L - timeDiff) {
                        ++i;
                    }
                    while (i > 0L) {
                        data.increaseDifficultyBy(current -> Float.valueOf(shouldIncrease && Config.CommonConfig.doIMDifficulty ? ((DifficultyConfig.Zone)Config.CommonConfig.increaseHandler.get(current.floatValue()).getRight()).start() : 0.0f), level.m_46468_(), level.m_7654_());
                        --i;
                    }
                }
            } else if (level.m_46468_() - data.getPrevTime() > 2400L) {
                data.increaseDifficultyBy(current -> Float.valueOf(shouldIncrease && Config.CommonConfig.doIMDifficulty ? ((DifficultyConfig.Zone)Config.CommonConfig.increaseHandler.get(current.floatValue()).getRight()).start() : 0.0f), level.m_46468_(), level.m_7654_());
            }
        }
    }

    public static void onEntityLoad(Mob mob) {
        List<EntityType<?>> types;
        boolean hasVillagerTarget;
        boolean aggressive;
        boolean ignoreSight;
        if (mob.m_9236_().f_46443_ || mob instanceof RiddenSummonEntity) {
            return;
        }
        if (((ISpawnReason)mob).getSpawnReason() == MobSpawnType.SPAWNER && Config.CommonConfig.ignoreSpawner) {
            return;
        }
        EntityFlags flags = EntityFlags.get((Entity)mob);
        boolean mobGriefing = mob.m_9236_().m_46469_().m_46207_(GameRules.f_46132_);
        float difficulty = DifficultyData.getDifficulty(mob.m_9236_(), (LivingEntity)mob);
        if (flags.canBreakBlocks == EntityFlags.FlagType.UNDEF) {
            flags.canBreakBlocks = difficulty >= Config.CommonConfig.difficultyBreak && Config.CommonConfig.breakerChance != 0.0f && mob.m_217043_().m_188501_() < Config.CommonConfig.breakerChance && !Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.BLOCKBREAK, Config.CommonConfig.mobListBreakWhitelist) ? EntityFlags.FlagType.TRUE : EntityFlags.FlagType.FALSE;
        }
        if (flags.canFly == EntityFlags.FlagType.UNDEF) {
            flags.canFly = mob.m_217043_().m_188501_() < Config.CommonConfig.flyAIChance && !Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.PARROT, Config.CommonConfig.mobListFlyWhitelist) ? EntityFlags.FlagType.TRUE : EntityFlags.FlagType.FALSE;
        }
        EventCalls.applyAttributesAndItems(mob, difficulty);
        if (!Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.USEITEM, Config.CommonConfig.mobListUseWhitelist)) {
            mob.f_21345_.m_25352_(1, (Goal)new ItemUseGoal(mob, 12.0f));
        }
        if (mob.m_217043_().m_188501_() < Config.CommonConfig.guardianAIChance && !Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.GUARDIAN, Config.CommonConfig.mobListBoatWhitelist) && !(((MobEntityMixin)mob).getTrueNavigator() instanceof WaterBoundPathNavigation) && !(mob instanceof Slime)) {
            mob.f_21345_.m_25352_(6, (Goal)new WaterRidingGoal(mob));
        }
        if (flags.canFly == EntityFlags.FlagType.TRUE && !(((MobEntityMixin)mob).getTrueNavigator() instanceof FlyingPathNavigation) && !(mob instanceof Slime)) {
            mob.f_21345_.m_25352_(6, (Goal)new FlyRidingGoal(mob));
        }
        if (!Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.LADDER, Config.CommonConfig.mobListLadderWhitelist) && !(mob.m_21573_() instanceof WallClimberNavigation)) {
            EntityFlags.get((Entity)mob).ladderClimber = true;
            mob.f_21345_.m_25352_(4, (Goal)new LadderClimbGoal(mob));
            ((INodeBreakable)mob.m_21573_().m_26575_()).setCanClimbLadder(true);
        }
        boolean villager = !Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.TARGETVILLAGER, Config.CommonConfig.targetVillagerWhitelist);
        boolean bl = ignoreSight = mob.m_217043_().m_188501_() < Config.CommonConfig.genericSightIgnore;
        if (mob instanceof NeutralMob && !Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.NEUTRALAGGRO, Config.CommonConfig.neutralAggroWhitelist)) {
            boolean bl2 = aggressive = Config.CommonConfig.neutralAggressiv != 0.0f && mob.m_217043_().m_188501_() < Config.CommonConfig.neutralAggressiv;
            if (aggressive) {
                mob.f_21346_.m_25352_(1, EventCalls.setNoLoS(mob, Player.class, ignoreSight, null));
            }
        } else {
            aggressive = true;
        }
        if (villager && aggressive && !(hasVillagerTarget = mob.f_21346_.m_148105_().stream().anyMatch(g -> {
            NearestTargetGoalMixin target;
            Goal patt0$temp;
            return g != null && (patt0$temp = g.m_26015_()) instanceof NearestTargetGoalMixin && (target = (NearestTargetGoalMixin)patt0$temp).targetTypeClss() == AbstractVillager.class;
        }))) {
            mob.f_21346_.m_25352_(3, EventCalls.setNoLoS(mob, AbstractVillager.class, ignoreSight, null));
        }
        if ((types = Config.CommonConfig.autoTargets.get(PlatformUtils.INSTANCE.entities().getIDFrom((Object)mob.m_6095_()))) != null) {
            mob.f_21346_.m_25352_(3, EventCalls.setNoLoS(mob, LivingEntity.class, ignoreSight, l -> types.contains(l.m_6095_())));
        }
        if (mob instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)mob;
            if (difficulty >= Config.CommonConfig.difficultySteal && mobGriefing && Config.CommonConfig.stealerChance != 0.0f && mob.m_217043_().m_188501_() < Config.CommonConfig.stealerChance && !Config.CommonConfig.entityBlacklist.hasFlag(mob, EntityModifyFlagConfig.Flags.STEAL, Config.CommonConfig.mobListStealWhitelist)) {
                pathfinderMob.f_21345_.m_25352_(5, (Goal)new StealGoal(pathfinderMob));
            }
        }
        if (flags.canBreakBlocks == EntityFlags.FlagType.TRUE) {
            mob.f_21346_.m_148105_().forEach(g -> {
                if (g != null && g.m_26015_() instanceof NearestAttackableTargetGoal && mob.m_217043_().m_188501_() < Config.CommonConfig.breakerSightIgnore) {
                    ((TargetGoalAccessor)g.m_26015_()).setShouldCheckSight(false);
                    ((NearestTargetGoalMixin)g.m_26015_()).getTargetEntitySelector().m_148355_();
                }
            });
            if (mobGriefing) {
                ((INodeBreakable)mob.m_21573_().m_26575_()).setCanBreakBlocks(true);
                mob.f_21345_.m_25352_(1, (Goal)new BlockBreakGoal(mob));
                if (mob.m_21206_().m_41619_()) {
                    ItemStack stack = Config.CommonConfig.getRandomBreakingItem(mob.m_217043_());
                    if (!Config.CommonConfig.shouldDropEquip) {
                        mob.m_21409_(EquipmentSlot.OFFHAND, -100.0f);
                    }
                    mob.m_8061_(EquipmentSlot.OFFHAND, stack);
                }
            }
        }
    }

    private static <T extends LivingEntity> NearestAttackableTargetGoal<T> setNoLoS(Mob e, Class<T> clss, boolean ignoreSight, Predicate<LivingEntity> pred) {
        NearestAttackableTargetGoal goal = pred == null ? new NearestAttackableTargetGoal(e, clss, !ignoreSight) : new NearestAttackableTargetGoal(e, clss, 10, !ignoreSight, false, pred);
        if (ignoreSight) {
            ((NearestTargetGoalMixin)goal).getTargetEntitySelector().m_148355_();
        }
        return goal;
    }

    private static void applyAttributesAndItems(Mob living, float difficulty) {
        EntityFlags flags = EntityFlags.get((Entity)living);
        if (!flags.modifyArmor) {
            if (!Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.ARMOR, Config.CommonConfig.armorMobWhitelist)) {
                Utils.equipArmor(living, difficulty);
            }
            flags.modifyArmor = true;
        }
        if (!flags.modifyHeldItems) {
            if (!Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.HELDITEMS, Config.CommonConfig.heldMobWhitelist)) {
                Utils.equipHeld(living, difficulty);
            }
            flags.modifyHeldItems = true;
        }
        if (!flags.enchantGear) {
            Utils.enchantGear(living, difficulty);
            flags.enchantGear = true;
        }
        if (!flags.modifyAttributes) {
            if (!Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.ATTRIBUTES, Config.CommonConfig.mobAttributeWhitelist)) {
                if (Config.CommonConfig.healthIncrease != 0.0 && !Config.CommonConfig.useScalingHealthMod.enabled()) {
                    Utils.modifyAttr(living, Attributes.f_22276_, Config.CommonConfig.healthIncrease * 0.016, Config.CommonConfig.healthMax, difficulty, true);
                    living.m_21153_(living.m_21233_());
                }
                if (Config.CommonConfig.damageIncrease != 0.0 && !Config.CommonConfig.useScalingHealthMod.enabled()) {
                    Utils.modifyAttr(living, Attributes.f_22281_, Config.CommonConfig.damageIncrease * 0.008, Config.CommonConfig.damageMax, difficulty, true);
                }
                if (Config.CommonConfig.speedIncrease != 0.0) {
                    Utils.modifyAttr(living, Attributes.f_22279_, Config.CommonConfig.speedIncrease * 8.0E-4, Config.CommonConfig.speedMax, difficulty, false);
                }
                if (Config.CommonConfig.knockbackIncrease != 0.0) {
                    Utils.modifyAttr(living, Attributes.f_22278_, Config.CommonConfig.knockbackIncrease * 0.002, Config.CommonConfig.knockbackMax, difficulty, false);
                }
                if (Config.CommonConfig.magicResIncrease != 0.0f) {
                    EntityFlags.get((Entity)living).magicRes = Math.min(Config.CommonConfig.magicResIncrease * 0.0016f * difficulty, Config.CommonConfig.magicResMax);
                }
                if (Config.CommonConfig.projectileIncrease != 0.0f) {
                    EntityFlags.get((Entity)living).projMult = 1.0f + (Config.CommonConfig.projectileMax <= 0.0f ? Config.CommonConfig.projectileIncrease * 0.008f * difficulty : Math.min(Config.CommonConfig.projectileIncrease * 0.008f * difficulty, Config.CommonConfig.projectileMax - 1.0f));
                }
                if (Config.CommonConfig.explosionIncrease != 0.0f) {
                    EntityFlags.get((Entity)living).explosionMult = 1.0f + (Config.CommonConfig.explosionMax <= 0.0f ? Config.CommonConfig.explosionIncrease * 0.003f * difficulty : Math.min(Config.CommonConfig.explosionIncrease * 0.003f * difficulty, Config.CommonConfig.explosionMax - 1.0f));
                }
            }
            flags.modifyAttributes = true;
        }
        if (Config.CommonConfig.varySizebyPehkui) {
            if (!flags.isVariedSize && living.m_217043_().m_188501_() < Config.CommonConfig.sizeChance && !Config.CommonConfig.entityBlacklist.hasFlag(living, EntityModifyFlagConfig.Flags.PEHKUI, Config.CommonConfig.pehkuiWhitelist)) {
                Utils.modifyScale(living, Config.CommonConfig.sizeMin, Config.CommonConfig.sizeMax);
            }
            flags.isVariedSize = true;
        }
    }

    public static float hurtEvent(LivingEntity entity, DamageSource source, float dmg) {
        if (source.m_269533_(DamageTypeTags.f_268524_) && source.m_7639_() instanceof Monster) {
            return dmg * EntityFlags.get((Entity)source.m_7639_()).projMult;
        }
        if (source.m_269533_(DamageTypeTags.f_268415_) && source.m_7639_() instanceof Monster) {
            return dmg * EntityFlags.get((Entity)source.m_7639_()).explosionMult;
        }
        if (entity instanceof Monster && source.m_269533_(DamageTypeTags.f_268731_)) {
            return dmg * (1.0f - EntityFlags.get((Entity)entity).magicRes);
        }
        return dmg;
    }

    public static boolean onAttackEvent(LivingEntity target, DamageSource damagesource) {
        if (!target.m_9236_().f_46443_) {
            LivingEntity attacker;
            if (!Config.CommonConfig.friendlyFire && target instanceof TamableAnimal) {
                TamableAnimal pet = (TamableAnimal)target;
                if (damagesource.m_7639_() != null && damagesource.m_7639_() == pet.m_269323_() && !damagesource.m_7639_().m_6144_()) {
                    return true;
                }
            }
            Entity source = damagesource.m_7639_();
            if (target instanceof Player) {
                Entity direct = damagesource.m_7640_();
                if (direct instanceof Snowball) {
                    EntityFlags flag = EntityFlags.get(direct);
                    if (flag.isThrownEntity) {
                        flag.isThrownEntity = false;
                        target.m_6469_(damagesource, 0.001f);
                    }
                }
            } else if (source instanceof LivingEntity && CrossPlatformStuff.INSTANCE.canDisableShield((attacker = (LivingEntity)source).m_21205_(), target.m_21211_(), target, attacker)) {
                EventCalls.triggerDisableShield(attacker, target);
            }
        }
        return false;
    }

    private static void triggerDisableShield(LivingEntity attacker, LivingEntity target) {
        float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)attacker) * 0.05f;
        if (attacker.m_20142_()) {
            f += 0.75f;
        }
        if (attacker.m_217043_().m_188501_() < f) {
            EntityFlags.get((Entity)target).disableShield();
            target.m_5810_();
            target.m_9236_().m_7605_((Entity)target, (byte)30);
        }
    }

    public static void openTile(Player player, BlockPos pos) {
        BlockEntity tile;
        if (!player.m_9236_().f_46443_ && !player.m_6144_() && (tile = player.m_9236_().m_7702_(pos)) != null) {
            CrossPlatformStuff.INSTANCE.onPlayerOpen(tile);
        }
    }

    public static boolean equipPet(Player player, InteractionHand hand, Entity target) {
        ItemStack heldItem;
        Item item;
        OwnableEntity pet;
        Mob mob;
        if (hand == InteractionHand.MAIN_HAND && target instanceof Mob && ((mob = (Mob)target) instanceof OwnableEntity || mob.m_6095_().m_204039_(ImprovedMobs.ARMOR_EQUIPPABLE)) && !target.m_9236_().f_46443_ && player.m_6144_() && !Utils.isInList(target, Config.CommonConfig.petArmorBlackList, Config.CommonConfig.petWhiteList, Utils.entityID) && (!(mob instanceof OwnableEntity) || player == (pet = (OwnableEntity)mob).m_269323_()) && (item = (heldItem = player.m_21205_()).m_41720_()) instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            EquipmentSlot type = armor.m_40402_();
            switch (type) {
                case HEAD: {
                    EventCalls.equipPetItem(player, mob, heldItem, EquipmentSlot.HEAD);
                    break;
                }
                case CHEST: {
                    EventCalls.equipPetItem(player, mob, heldItem, EquipmentSlot.CHEST);
                    break;
                }
                case LEGS: {
                    EventCalls.equipPetItem(player, mob, heldItem, EquipmentSlot.LEGS);
                    break;
                }
                case FEET: {
                    EventCalls.equipPetItem(player, mob, heldItem, EquipmentSlot.FEET);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private static void equipPetItem(Player player, Mob living, ItemStack stack, EquipmentSlot slot) {
        ItemStack current = living.m_6844_(slot);
        if (!current.m_41619_() && !player.m_7500_()) {
            ItemEntity entityitem = new ItemEntity(living.m_9236_(), living.m_20185_(), living.m_20186_(), living.m_20189_(), current);
            entityitem.m_32061_();
            living.m_9236_().m_7967_((Entity)entityitem);
        }
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(1);
        living.m_8061_(slot, copy);
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
    }

    public static boolean projectileImpact(Projectile projectile, HitResult hitResult) {
        EntityHitResult res;
        Entity thrower;
        return EntityFlags.get((Entity)projectile).isThrownEntity && (thrower = projectile.m_19749_()) instanceof Mob && !(projectile instanceof ThrownPotion) && hitResult.m_6662_() == HitResult.Type.ENTITY && !(res = (EntityHitResult)hitResult).m_82443_().equals((Object)((Mob)thrower).m_5448_());
    }

    public static void explosion(Explosion explosion, Entity source, List<Entity> affectedEntities) {
        if (source instanceof PrimedTnt && EntityFlags.get((Entity)source).isThrownEntity) {
            LivingEntity igniter;
            if (!Config.CommonConfig.tntBlockDestruction) {
                explosion.m_46081_().clear();
            }
            if ((igniter = explosion.m_252906_()) instanceof Mob) {
                affectedEntities.removeIf(e -> !e.equals((Object)((Mob)igniter).m_5448_()));
            }
        }
    }
}

