/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.config;

import io.github.flemmli97.tenshilib.api.config.IConfigListValue;
import io.github.flemmli97.tenshilib.common.utils.SearchUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class DifficultyConfig
implements IConfigListValue<DifficultyConfig> {
    private static final Pair<Float, Zone> DEFAULT_VAL = Pair.of((Object)Float.valueOf(0.0f), (Object)new Zone(1.0f, 0.01f));
    private final List<Pair<Float, Zone>> vals = new ArrayList<Pair<Float, Zone>>();

    public DifficultyConfig(List<Pair<Float, Zone>> defaultVal) {
        this.vals.addAll(defaultVal);
    }

    public DifficultyConfig readFromString(List<String> ss) {
        this.vals.clear();
        ArrayList<Pair> list = new ArrayList<Pair>();
        for (String s : ss) {
            String[] parts;
            String[] stringArray = parts = s.contains("|") ? s.split("\\|") : s.split("-");
            if (parts.length == 3) {
                list.add(Pair.of((Object)Float.valueOf(Float.parseFloat(parts[0])), (Object)new Zone(Float.parseFloat(parts[1]), Float.parseFloat(parts[2]))));
                continue;
            }
            if (parts.length != 2) continue;
            list.add(Pair.of((Object)Float.valueOf(Float.parseFloat(parts[0])), (Object)new Zone(Float.parseFloat(parts[1]), 0.0f)));
        }
        list.sort((o1, o2) -> Float.compare(((Float)o1.getLeft()).floatValue(), ((Float)o2.getLeft()).floatValue()));
        this.vals.addAll(list);
        return this;
    }

    public List<String> writeToString() {
        ArrayList<String> list = new ArrayList<String>();
        this.vals.forEach(v -> list.add(String.valueOf(v.getLeft()) + "-" + ((Zone)v.getRight()).write()));
        return list;
    }

    public Pair<Float, Zone> get(float difficulty) {
        return (Pair)SearchUtils.searchInfFunc(this.vals, v -> Float.compare(((Float)v.getLeft()).floatValue(), difficulty), DEFAULT_VAL);
    }

    public record Zone(float start, float increasePerBlock) {
        public static Zone of(float start) {
            return new Zone(start, 0.0f);
        }

        String write() {
            if (this.increasePerBlock == 0.0f) {
                return "" + this.start;
            }
            return this.start + "-" + this.increasePerBlock;
        }
    }
}

