/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.improvedmobs.ai;

import io.github.flemmli97.improvedmobs.api.difficulty.DifficultyFetcher;
import io.github.flemmli97.improvedmobs.config.Config;
import io.github.flemmli97.improvedmobs.platform.CrossPlatformStuff;
import io.github.flemmli97.improvedmobs.utils.BlockRestorationData;
import io.github.flemmli97.improvedmobs.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class BlockBreakGoal
extends Goal {
    protected final Mob living;
    private LivingEntity target;
    private BlockPos markedLoc;
    private BlockPos entityPos;
    private int digTimer;
    private int cooldown = Config.CommonConfig.breakerInitCooldown;
    private final List<BlockPos> breakAOE = new ArrayList<BlockPos>();
    private int breakIndex;
    private final int digHeight;

    public BlockBreakGoal(Mob living) {
        this.living = living;
        int digWidth = living.m_20205_() < 1.0f ? 0 : Mth.m_14167_((float)living.m_20205_());
        for (int i = this.digHeight = (int)living.m_20206_() + 1; i >= 0; --i) {
            this.breakAOE.add(new BlockPos(0, i, 0));
        }
        for (int z = digWidth + 1; z >= -digWidth; --z) {
            for (int y = this.digHeight; y >= 0; --y) {
                for (int x = 0; x <= digWidth; ++x) {
                    if (z == 0) continue;
                    this.breakAOE.add(new BlockPos(x, y, z));
                    if (x == 0) continue;
                    this.breakAOE.add(new BlockPos(-x, y, z));
                }
            }
        }
    }

    public boolean m_8036_() {
        this.target = this.living.m_5448_();
        if (this.entityPos == null) {
            this.entityPos = this.living.m_20183_();
            this.cooldown = Config.CommonConfig.breakerCooldown;
        }
        if (--this.cooldown <= 0) {
            if (!this.entityPos.equals((Object)this.living.m_20183_())) {
                this.entityPos = null;
                this.cooldown = Config.CommonConfig.breakerCooldown;
                return false;
            }
            if (this.target != null && (double)this.living.m_20270_((Entity)this.target) > 1.0) {
                BlockPos blockPos = this.getDiggingLocation();
                if (blockPos == null) {
                    return false;
                }
                this.cooldown = Config.CommonConfig.breakerCooldown;
                this.markedLoc = blockPos;
                this.entityPos = this.living.m_20183_();
                return true;
            }
        }
        return false;
    }

    public boolean m_8045_() {
        return this.target != null && this.target.m_6084_() && this.living.m_6084_() && this.markedLoc != null && this.nearSameSpace(this.entityPos, this.living.m_20183_()) && (double)this.living.m_20270_((Entity)this.target) > 1.0;
    }

    private boolean nearSameSpace(BlockPos pos1, BlockPos pos2) {
        return pos1 != null && pos2 != null && pos1.m_123341_() == pos2.m_123341_() && pos1.m_123343_() == pos2.m_123343_() && Math.abs(pos1.m_123342_() - pos2.m_123342_()) <= 1;
    }

    public void m_8041_() {
        this.breakIndex = 0;
        if (this.markedLoc != null) {
            this.living.m_9236_().m_6801_(this.living.m_19879_(), this.markedLoc, -1);
        }
        this.markedLoc = null;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.markedLoc == null || this.living.m_9236_().m_8055_(this.markedLoc).m_60812_((BlockGetter)this.living.m_9236_(), this.markedLoc).m_83281_()) {
            this.digTimer = 0;
            return;
        }
        BlockState state = this.living.m_9236_().m_8055_(this.markedLoc);
        float str = Utils.getBlockStrength(this.living, state, this.living.m_9236_(), this.markedLoc);
        float f = str = str == Float.POSITIVE_INFINITY ? 1.0f : str / (1.0f + str * 6.0f) * ((float)this.digTimer * this.breakSpeedMod() + 1.0f);
        if (str >= 1.0f) {
            boolean canHarvest;
            Level level;
            this.digTimer = 0;
            this.cooldown = (int)((double)this.cooldown * 0.5);
            ItemStack item = this.living.m_21205_();
            ItemStack itemOff = this.living.m_21206_();
            if (Config.CommonConfig.restoreDelay > 0 && (level = this.living.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                canHarvest = false;
                BlockRestorationData.get(serverLevel).restore(serverLevel, serverLevel.m_8055_(this.markedLoc), this.markedLoc, (Entity)this.living);
            } else {
                canHarvest = Utils.canHarvest(state, item) || Utils.canHarvest(state, itemOff);
            }
            this.living.m_9236_().m_46961_(this.markedLoc, canHarvest);
            this.living.m_9236_().m_6801_(this.living.m_19879_(), this.markedLoc, -1);
            this.markedLoc = null;
            if (!this.aboveTarget()) {
                this.living.m_7910_(0.0f);
                this.living.m_21573_().m_26573_();
                this.living.m_21573_().m_26536_(this.living.m_21573_().m_6570_((Entity)this.target, 0), 1.0);
            }
        } else {
            ++this.digTimer;
            if (this.digTimer % 5 == 0) {
                SoundType sound = CrossPlatformStuff.INSTANCE.blockSound(state, (LivingEntity)this.living, this.markedLoc);
                this.living.m_9236_().m_262808_(null, (double)this.markedLoc.m_123341_() + 0.5, (double)this.markedLoc.m_123342_() + 0.5, (double)this.markedLoc.m_123343_() + 0.5, (Holder)(Config.CommonConfig.useBlockBreakSound ? BuiltInRegistries.f_256894_.m_263177_((Object)sound.m_56775_()) : SoundEvents.f_12209_), SoundSource.BLOCKS, 2.0f, 0.5f, this.living.m_9236_().m_213780_().m_188505_());
                this.living.m_6674_(InteractionHand.MAIN_HAND);
                this.living.m_21563_().m_24950_((double)this.markedLoc.m_123341_(), (double)this.markedLoc.m_123342_(), (double)this.markedLoc.m_123343_(), 0.0f, 0.0f);
                this.living.m_9236_().m_6801_(this.living.m_19879_(), this.markedLoc, (int)(str * 10.0f) - 1);
            }
        }
    }

    private float breakSpeedMod() {
        float mod = Config.CommonConfig.breakSpeedBaseMod;
        if (Config.CommonConfig.breakSpeedAdd != 0.0f) {
            mod += Config.CommonConfig.breakSpeedAdd * DifficultyFetcher.getDifficulty((ServerLevel)this.living.m_9236_(), this.living.m_20182_());
        }
        return mod;
    }

    public BlockPos getDiggingLocation() {
        BlockState state;
        ItemStack item = this.living.m_21205_();
        ItemStack itemOff = this.living.m_21206_();
        BlockPos pos = this.living.m_20183_();
        if (this.living.m_5448_() != null) {
            Vec3 target = this.living.m_5448_().m_20182_();
            if (this.aboveTarget() && Math.abs(target.f_82479_ - (double)pos.m_123341_()) <= 1.0 && Math.abs(target.f_82481_ - (double)pos.m_123343_()) <= 1.0) {
                pos = this.living.m_20183_().m_7495_();
                state = this.living.m_9236_().m_8055_(pos);
                if (this.canBreak((LivingEntity)this.living, state, pos, item, itemOff)) {
                    this.breakIndex = 0;
                    return pos;
                }
            }
        }
        Rotation rot = BlockBreakGoal.getDigDirection(this.living);
        BlockPos offset = this.breakAOE.get(this.breakIndex);
        offset = new BlockPos(offset.m_123341_(), this.aboveTarget() ? -(offset.m_123342_() - this.digHeight) : offset.m_123342_(), offset.m_123343_());
        pos = pos.m_121955_((Vec3i)offset.m_7954_(rot));
        state = this.living.m_9236_().m_8055_(pos);
        if (this.canBreak((LivingEntity)this.living, state, pos, item, itemOff)) {
            this.breakIndex = 0;
            return pos;
        }
        ++this.breakIndex;
        if (this.breakIndex == this.breakAOE.size()) {
            this.breakIndex = 0;
        }
        return null;
    }

    private boolean canBreak(LivingEntity entity, BlockState state, BlockPos pos, ItemStack item, ItemStack itemOff) {
        return Config.CommonConfig.breakableBlocks.canBreak(state, pos, (BlockGetter)entity.m_9236_(), (Entity)entity, CollisionContext.m_82750_((Entity)entity)) && (Utils.canHarvest(state, item) || Utils.canHarvest(state, itemOff));
    }

    private boolean aboveTarget() {
        return this.target.m_20186_() < this.living.m_20186_() + 1.1;
    }

    public static Rotation getDigDirection(Mob mob) {
        Path path = mob.m_21573_().m_26570_();
        if (path != null) {
            Node point;
            Node node = point = path.m_77399_() < path.m_77398_() ? path.m_77401_() : null;
            if (point != null) {
                Vec3 dir = new Vec3((double)point.f_77271_ + 0.5, mob.m_20182_().f_82480_, (double)point.f_77273_ + 0.5).m_82546_(mob.m_20182_());
                if (Math.abs(dir.f_82479_) < Math.abs(dir.f_82481_)) {
                    if (dir.f_82481_ >= 0.0) {
                        return Rotation.NONE;
                    }
                    return Rotation.CLOCKWISE_180;
                }
                if (dir.f_82479_ > 0.0) {
                    return Rotation.COUNTERCLOCKWISE_90;
                }
                return Rotation.CLOCKWISE_90;
            }
        }
        return switch (mob.m_6350_()) {
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        };
    }
}

