/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.coroutil.util;

import com.corosus.coroutil.config.ConfigCoroUtil;
import com.corosus.coroutil.util.CULog;
import com.corosus.coroutil.util.CoroUtilBlock;
import com.corosus.coroutil.util.CoroUtilCompatibility;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathComputationType;

public class CoroUtilPath {
    public static boolean tryMoveToEntityLivingLongDist(Mob entSource, Entity entityTo, double moveSpeedAmp) {
        return CoroUtilPath.tryMoveToXYZLongDist(entSource, entityTo.m_20185_(), entityTo.m_20191_().f_82289_, entityTo.m_20189_(), moveSpeedAmp);
    }

    public static boolean tryMoveToXYZLongDist(Mob ent, double x, double y, double z, double moveSpeedAmp) {
        boolean success;
        block12: {
            Level world = ent.m_9236_();
            success = false;
            try {
                int tries;
                int gatherZ;
                int gatherY;
                double followDist;
                if (!ent.m_21573_().m_26571_()) break block12;
                double distToPlayer = Math.sqrt(ent.m_20275_(x, y, z));
                if (distToPlayer <= (followDist = ent.m_21051_(Attributes.f_22277_).m_22135_())) {
                    success = CoroUtilCompatibility.tryPathToXYZModCompat(ent, Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z), moveSpeedAmp);
                    break block12;
                }
                double d = x + 0.5 - ent.m_20185_();
                double d2 = z + 0.5 - ent.m_20189_();
                double d1 = y + 0.5 - (ent.m_20186_() + (double)ent.m_20192_());
                double d3 = Mth.m_14116_((float)((float)(d * d + d2 * d2)));
                float f2 = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
                float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / 3.1415927410125732));
                float rotationPitch = -f3;
                float rotationYaw = f2;
                Mob center = ent;
                Random rand = new Random();
                float randLook = rand.nextInt(90) - 45;
                double dist = followDist * 0.75 + (double)rand.nextInt((int)followDist / 2);
                int gatherX = (int)Math.floor(center.m_20185_() + -Math.sin((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist);
                BlockPos pos = new BlockPos(gatherX, gatherY = (int)center.m_20186_(), gatherZ = (int)Math.floor(center.m_20189_() + Math.cos((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist));
                if (!world.m_46749_(pos)) {
                    return false;
                }
                BlockState state = world.m_8055_(pos);
                if (!CoroUtilBlock.isAir(state.m_60734_())) {
                    int offset = -5;
                    for (tries = 0; tries < 30 && !CoroUtilBlock.isAir(state.m_60734_()) && state.m_60647_((BlockGetter)ent.m_9236_(), pos, PathComputationType.LAND); ++tries) {
                        pos = new BlockPos(gatherX, gatherY += offset++, gatherZ);
                        state = world.m_8055_(pos);
                    }
                } else {
                    while (tries < 30 && (CoroUtilBlock.isAir(state.m_60734_()) || !state.m_60647_((BlockGetter)ent.m_9236_(), pos, PathComputationType.LAND))) {
                        pos = new BlockPos(gatherX, --gatherY, gatherZ);
                        state = world.m_8055_(pos);
                        ++tries;
                    }
                }
                if (tries < 30) {
                    success = CoroUtilCompatibility.tryPathToXYZModCompat(ent, gatherX, gatherY, gatherZ, moveSpeedAmp);
                } else {
                    if (!world.m_46749_(pos = new BlockPos(pos.m_123341_(), world.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_()), pos.m_123343_()).m_7495_())) {
                        return false;
                    }
                    state = world.m_8055_(pos);
                    if (state.m_60647_((BlockGetter)ent.m_9236_(), pos, PathComputationType.LAND)) {
                        success = CoroUtilCompatibility.tryPathToXYZModCompat(ent, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), moveSpeedAmp);
                    }
                }
            }
            catch (Exception ex) {
                CULog.err("Exception trying to pathfind");
                if (!ConfigCoroUtil.useLoggingError) break block12;
                ex.printStackTrace();
            }
        }
        return success;
    }
}

