/*
 * Decompiled with CFR 0.152.
 */
package net.dadamalda.create_compatible_storage;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynServerResourcesGenerator;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicDataPack;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Logger;

public class DynamicTags {
    public static void init() {
        ServerDataGenerator generator = new ServerDataGenerator();
        generator.register();
    }

    public static class ServerDataGenerator
    extends DynServerResourcesGenerator {
        protected ServerDataGenerator() {
            super(new DynamicDataPack(ResourceLocation.parse((String)"create_compatible_storage:everycomp_tags")));
            ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"create"});
            ((DynamicDataPack)this.getPack()).addNamespaces(new String[]{"create_compatible_storage"});
        }

        public Logger getLogger() {
            return Moonlight.LOGGER;
        }

        public boolean dependsOnLoadedPacks() {
            return true;
        }

        public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
            super.regenerateDynamicAssets(executor);
            boolean isChestModLoaded = ModList.get().isLoaded("quark") || ModList.get().isLoaded("lolmcv") || ModList.get().isLoaded("woodworks");
            boolean isStoneChestsLoaded = ModList.get().isLoaded("stonechest");
            boolean isFarmersDelightLoaded = ModList.get().isLoaded("farmersdelight");
            boolean isFurnitureRefurbishedLoaded = ModList.get().isLoaded("refurbished_furniture");
            executor.accept((resourceManager, resourceSink) -> {
                TagKey tagKey = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)ResourceLocation.parse((String)"create:chest_mounted_storage"));
                SimpleTagBuilder tag = SimpleTagBuilder.of((TagKey)tagKey);
                Pattern pattern1 = Pattern.compile("^(?:q|mcv|abnww)/.*_chest$");
                Pattern pattern2 = Pattern.compile("^sc/.*$");
                for (Block b : ForgeRegistries.BLOCKS) {
                    ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)b);
                    if (isChestModLoaded && key != null && key.m_135827_().equals("everycomp") && pattern1.matcher(key.m_135815_()).matches()) {
                        tag.add(key);
                    }
                    if (!isStoneChestsLoaded || key == null || !key.m_135827_().equals("stonezone") || !pattern2.matcher(key.m_135815_()).matches()) continue;
                    tag.add(key);
                }
                resourceSink.addTag(tag, Registries.f_256747_);
            });
            executor.accept((resourceManager, resourceSink) -> {
                TagKey tagKey1 = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)ResourceLocation.parse((String)"create:simple_mounted_storage"));
                TagKey tagKey2 = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)ResourceLocation.parse((String)"create:single_block_inventories"));
                SimpleTagBuilder tag1 = SimpleTagBuilder.of((TagKey)tagKey1);
                SimpleTagBuilder tag2 = SimpleTagBuilder.of((TagKey)tagKey2);
                Pattern pattern1 = Pattern.compile("^fd/.*_cabinet$");
                Pattern pattern2 = Pattern.compile("^rfm/.*_(?:storage_cabinet|drawer|kitchen_drawwer|kitchen_storage_cabinet|crate|mail_box)$");
                for (Block b : ForgeRegistries.BLOCKS) {
                    ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)b);
                    if (isFarmersDelightLoaded && key != null && key.m_135827_().equals("everycomp") && pattern1.matcher(key.m_135815_()).matches()) {
                        tag1.add(key);
                        tag2.add(key);
                    }
                    if (!isFurnitureRefurbishedLoaded || key == null || !key.m_135827_().equals("everycomp") || !pattern2.matcher(key.m_135815_()).matches()) continue;
                    tag1.add(key);
                    tag2.add(key);
                }
                resourceSink.addTag(tag1, Registries.f_256747_);
                resourceSink.addTag(tag2, Registries.f_256747_);
            });
        }
    }
}

