/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.utils;

import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.connector.mysql.MySqlPartition;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.cdc.common.schema.Column;
import org.apache.flink.cdc.common.schema.Schema;
import org.apache.flink.cdc.common.types.DataType;
import org.apache.flink.cdc.connectors.mysql.debezium.DebeziumUtils;
import org.apache.flink.cdc.connectors.mysql.schema.MySqlSchema;
import org.apache.flink.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import org.apache.flink.cdc.connectors.mysql.source.utils.StatementUtils;
import org.apache.flink.cdc.connectors.mysql.utils.MySqlTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlSchemaUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlSchemaUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> listDatabases(MySqlSourceConfig sourceConfig) {
        try (MySqlConnection jdbc = DebeziumUtils.createMySqlConnection(sourceConfig);){
            List<String> list = MySqlSchemaUtils.listDatabases(jdbc);
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error to list databases: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<org.apache.flink.cdc.common.event.TableId> listTables(MySqlSourceConfig sourceConfig, @Nullable String dbName) {
        try (MySqlConnection jdbc = DebeziumUtils.createMySqlConnection(sourceConfig);){
            List<String> databases = dbName != null ? Collections.singletonList(dbName) : MySqlSchemaUtils.listDatabases(jdbc);
            ArrayList<org.apache.flink.cdc.common.event.TableId> tableIds = new ArrayList<org.apache.flink.cdc.common.event.TableId>();
            for (String database : databases) {
                tableIds.addAll(MySqlSchemaUtils.listTables(jdbc, database));
            }
            ArrayList<org.apache.flink.cdc.common.event.TableId> arrayList = tableIds;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error to list databases: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Schema getTableSchema(MySqlSourceConfig sourceConfig, MySqlPartition partition, org.apache.flink.cdc.common.event.TableId tableId) {
        try (MySqlConnection jdbc = DebeziumUtils.createMySqlConnection(sourceConfig);){
            Schema schema = MySqlSchemaUtils.getTableSchema(partition, tableId, sourceConfig, jdbc);
            return schema;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error to get table schema: " + e.getMessage(), e);
        }
    }

    public static List<String> listDatabases(JdbcConnection jdbc) throws SQLException {
        LOG.info("Read list of available databases");
        ArrayList<String> databaseNames = new ArrayList<String>();
        jdbc.query("SHOW DATABASES WHERE `database` NOT IN ('information_schema', 'mysql', 'performance_schema', 'sys')", rs -> {
            while (rs.next()) {
                databaseNames.add(rs.getString(1));
            }
        });
        LOG.info("\t list of available databases are: {}", databaseNames);
        return databaseNames;
    }

    public static List<org.apache.flink.cdc.common.event.TableId> listTables(JdbcConnection jdbc, String dbName) throws SQLException {
        LOG.info("Read list of available tables in {}", (Object)dbName);
        ArrayList<org.apache.flink.cdc.common.event.TableId> tableIds = new ArrayList<org.apache.flink.cdc.common.event.TableId>();
        jdbc.query("SHOW FULL TABLES IN " + StatementUtils.quote(dbName) + " where Table_Type = 'BASE TABLE'", rs -> {
            while (rs.next()) {
                tableIds.add(org.apache.flink.cdc.common.event.TableId.tableId((String)dbName, (String)rs.getString(1)));
            }
        });
        LOG.info("\t list of available tables are: {}", tableIds);
        return tableIds;
    }

    public static Schema getTableSchema(MySqlPartition partition, org.apache.flink.cdc.common.event.TableId tableId, MySqlSourceConfig sourceConfig, MySqlConnection jdbc) {
        try (MySqlSchema mySqlSchema = new MySqlSchema(sourceConfig, jdbc.isTableIdCaseSensitive());){
            TableChanges.TableChange tableSchema = mySqlSchema.getTableSchema(partition, jdbc, MySqlSchemaUtils.toDbzTableId(tableId));
            Schema schema = MySqlSchemaUtils.toSchema(tableSchema.getTable(), sourceConfig.isTreatTinyInt1AsBoolean());
            return schema;
        }
    }

    public static Schema toSchema(Table table, boolean tinyInt1isBit) {
        List columns = table.columns().stream().map(column -> MySqlSchemaUtils.toColumn(column, tinyInt1isBit)).collect(Collectors.toList());
        return Schema.newBuilder().setColumns(columns).primaryKey(table.primaryKeyColumnNames()).comment(table.comment()).build();
    }

    public static Column toColumn(io.debezium.relational.Column column, boolean tinyInt1isBit) {
        return Column.physicalColumn((String)column.name(), (DataType)MySqlTypeUtils.fromDbzColumn(column, tinyInt1isBit), (String)column.comment());
    }

    public static TableId toDbzTableId(org.apache.flink.cdc.common.event.TableId tableId) {
        return new TableId(tableId.getSchemaName(), null, tableId.getTableName());
    }

    private MySqlSchemaUtils() {
    }
}

