/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source.assigners;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.util.Preconditions;

class ChunkRange {
    @Nullable
    private final Object chunkStart;
    @Nullable
    private final Object chunkEnd;

    public static ChunkRange all() {
        return new ChunkRange(null, null);
    }

    public static ChunkRange of(Object chunkStart, Object chunkEnd) {
        return new ChunkRange(chunkStart, chunkEnd);
    }

    private ChunkRange(@Nullable Object chunkStart, @Nullable Object chunkEnd) {
        if (chunkStart != null || chunkEnd != null) {
            Preconditions.checkArgument((!Objects.equals(chunkStart, chunkEnd) ? 1 : 0) != 0, (String)"Chunk start %s shouldn't be equal to chunk end %s", (Object[])new Object[]{chunkStart, chunkEnd});
        }
        this.chunkStart = chunkStart;
        this.chunkEnd = chunkEnd;
    }

    @Nullable
    public Object getChunkStart() {
        return this.chunkStart;
    }

    @Nullable
    public Object getChunkEnd() {
        return this.chunkEnd;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkRange that = (ChunkRange)o;
        return Objects.equals(this.chunkStart, that.chunkStart) && Objects.equals(this.chunkEnd, that.chunkEnd);
    }

    public int hashCode() {
        return Objects.hash(this.chunkStart, this.chunkEnd);
    }

    public String toString() {
        return "ChunkRange{chunkStart=" + this.chunkStart + ", chunkEnd=" + this.chunkEnd + '}';
    }
}

