/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source;

import com.esri.core.geometry.ogc.OGCGeometry;
import io.debezium.relational.Tables;
import io.debezium.relational.history.HistoryRecord;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.cdc.common.annotation.Internal;
import org.apache.flink.cdc.common.data.binary.BinaryStringData;
import org.apache.flink.cdc.common.event.SchemaChangeEvent;
import org.apache.flink.cdc.common.event.TableId;
import org.apache.flink.cdc.connectors.mysql.source.MySqlSchemaDataTypeInference;
import org.apache.flink.cdc.connectors.mysql.source.parser.CustomMySqlAntlrDdlParser;
import org.apache.flink.cdc.connectors.mysql.source.utils.RecordUtils;
import org.apache.flink.cdc.connectors.mysql.table.MySqlReadableMetadata;
import org.apache.flink.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.cdc.connectors.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import org.apache.flink.cdc.debezium.event.DebeziumEventDeserializationSchema;
import org.apache.flink.cdc.debezium.table.DebeziumChangelogMode;
import org.apache.flink.table.data.TimestampData;

@Internal
public class MySqlEventDeserializer
extends DebeziumEventDeserializationSchema {
    private static final long serialVersionUID = 1L;
    public static final String SCHEMA_CHANGE_EVENT_KEY_NAME = "io.debezium.connector.mysql.SchemaChangeKey";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final boolean includeSchemaChanges;
    private final boolean tinyInt1isBit;
    private final boolean includeComments;
    private transient Tables tables;
    private transient CustomMySqlAntlrDdlParser customParser;
    private List<MySqlReadableMetadata> readableMetadataList;

    public MySqlEventDeserializer(DebeziumChangelogMode changelogMode, boolean includeSchemaChanges, boolean tinyInt1isBit) {
        this(changelogMode, includeSchemaChanges, new ArrayList<MySqlReadableMetadata>(), includeSchemaChanges, tinyInt1isBit);
    }

    public MySqlEventDeserializer(DebeziumChangelogMode changelogMode, boolean includeSchemaChanges, List<MySqlReadableMetadata> readableMetadataList, boolean includeComments, boolean tinyInt1isBit) {
        super(new MySqlSchemaDataTypeInference(), changelogMode);
        this.includeSchemaChanges = includeSchemaChanges;
        this.readableMetadataList = readableMetadataList;
        this.includeComments = includeComments;
        this.tinyInt1isBit = tinyInt1isBit;
    }

    @Override
    protected List<SchemaChangeEvent> deserializeSchemaChangeRecord(SourceRecord record) {
        if (this.includeSchemaChanges) {
            if (this.customParser == null) {
                this.customParser = new CustomMySqlAntlrDdlParser(this.includeComments, this.tinyInt1isBit);
                this.tables = new Tables();
            }
            try {
                HistoryRecord historyRecord = RecordUtils.getHistoryRecord(record);
                String databaseName = historyRecord.document().getString("databaseName");
                String ddl = historyRecord.document().getString("ddl");
                this.customParser.setCurrentDatabase(databaseName);
                this.customParser.parse(ddl, this.tables);
                return this.customParser.getAndClearParsedEvents();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to parse the schema change : " + record, e);
            }
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean isDataChangeRecord(SourceRecord record) {
        Schema valueSchema = record.valueSchema();
        Struct value = (Struct)record.value();
        return value != null && valueSchema != null && valueSchema.field("op") != null && value.getString("op") != null;
    }

    @Override
    protected boolean isSchemaChangeRecord(SourceRecord record) {
        Schema keySchema = record.keySchema();
        return keySchema != null && SCHEMA_CHANGE_EVENT_KEY_NAME.equalsIgnoreCase(keySchema.name());
    }

    @Override
    protected TableId getTableId(SourceRecord record) {
        String[] parts = record.topic().split("\\.");
        return TableId.tableId((String)parts[1], (String)parts[2]);
    }

    @Override
    protected Map<String, String> getMetadata(SourceRecord record) {
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        this.readableMetadataList.forEach(mySqlReadableMetadata -> {
            Object metadata = mySqlReadableMetadata.getConverter().read(record);
            if (mySqlReadableMetadata.equals((Object)MySqlReadableMetadata.OP_TS)) {
                metadataMap.put(mySqlReadableMetadata.getKey(), String.valueOf(((TimestampData)metadata).getMillisecond()));
            } else {
                metadataMap.put(mySqlReadableMetadata.getKey(), String.valueOf(metadata));
            }
        });
        return metadataMap;
    }

    @Override
    protected Object convertToString(Object dbzObj, Schema schema) {
        if ("io.debezium.data.geometry.Point".equals(schema.name()) || "io.debezium.data.geometry.Geometry".equals(schema.name())) {
            try {
                Struct geometryStruct = (Struct)dbzObj;
                byte[] wkb = geometryStruct.getBytes("wkb");
                String geoJson = OGCGeometry.fromBinary(ByteBuffer.wrap(wkb)).asGeoJson();
                JsonNode originGeoNode = OBJECT_MAPPER.readTree(geoJson);
                Optional<Integer> srid = Optional.ofNullable(geometryStruct.getInt32("srid"));
                HashMap<String, Object> geometryInfo = new HashMap<String, Object>();
                String geometryType = originGeoNode.get("type").asText();
                geometryInfo.put("type", geometryType);
                if (geometryType.equals("GeometryCollection")) {
                    geometryInfo.put("geometries", originGeoNode.get("geometries"));
                } else {
                    geometryInfo.put("coordinates", originGeoNode.get("coordinates"));
                }
                geometryInfo.put("srid", srid.orElse(0));
                return BinaryStringData.fromString((String)OBJECT_MAPPER.writer().writeValueAsString(geometryInfo));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Failed to convert %s to geometry JSON.", dbzObj), e);
            }
        }
        return BinaryStringData.fromString((String)dbzObj.toString());
    }
}

