/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.mysql.source;

import java.time.Duration;
import org.apache.flink.cdc.common.annotation.Experimental;
import org.apache.flink.cdc.common.annotation.PublicEvolving;
import org.apache.flink.cdc.common.configuration.ConfigOption;
import org.apache.flink.cdc.common.configuration.ConfigOptions;

@PublicEvolving
public class MySqlDataSourceOptions {
    public static final ConfigOption<String> HOSTNAME = ConfigOptions.key((String)"hostname").stringType().noDefaultValue().withDescription("IP address or hostname of the MySQL database server.");
    public static final ConfigOption<Integer> PORT = ConfigOptions.key((String)"port").intType().defaultValue((Object)3306).withDescription("Integer port number of the MySQL database server.");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("Name of the MySQL database to use when connecting to the MySQL database server.");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("Password to use when connecting to the MySQL database server.");
    public static final ConfigOption<String> TABLES = ConfigOptions.key((String)"tables").stringType().noDefaultValue().withDescription("Table names of the MySQL tables to monitor. Regular expressions are supported. It is important to note that the dot (.) is treated as a delimiter for database and table names. If there is a need to use a dot (.) in a regular expression to match any character, it is necessary to escape the dot with a backslash.eg. db0.\\.*, db1.user_table_[0-9]+, db[1-2].[app|web]_order_\\.*");
    public static final ConfigOption<String> SERVER_TIME_ZONE = ConfigOptions.key((String)"server-time-zone").stringType().noDefaultValue().withDescription("The session time zone in database server. If not set, then ZoneId.systemDefault() is used to determine the server time zone.");
    public static final ConfigOption<String> SERVER_ID = ConfigOptions.key((String)"server-id").stringType().noDefaultValue().withDescription("A numeric ID or a numeric ID range of this database client, The numeric ID syntax is like '5400', the numeric ID range syntax is like '5400-5408', The numeric ID range syntax is recommended when 'scan.incremental.snapshot.enabled' enabled. Every ID must be unique across all currently-running database processes in the MySQL cluster. This connector joins the MySQL  cluster as another server (with this unique ID) so it can read the binlog. By default, a random number is generated between 5400 and 6400, though we recommend setting an explicit value.");
    public static final ConfigOption<Integer> SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE = ConfigOptions.key((String)"scan.incremental.snapshot.chunk.size").intType().defaultValue((Object)8096).withDescription("The chunk size (number of rows) of table snapshot, captured tables are split into multiple chunks when read the snapshot of table.");
    public static final ConfigOption<Integer> SCAN_SNAPSHOT_FETCH_SIZE = ConfigOptions.key((String)"scan.snapshot.fetch.size").intType().defaultValue((Object)1024).withDescription("The maximum fetch size for per poll when read table snapshot.");
    public static final ConfigOption<Duration> CONNECT_TIMEOUT = ConfigOptions.key((String)"connect.timeout").durationType().defaultValue((Object)Duration.ofSeconds(30L)).withDescription("The maximum time that the connector should wait after trying to connect to the MySQL database server before timing out.");
    public static final ConfigOption<Integer> CONNECTION_POOL_SIZE = ConfigOptions.key((String)"connection.pool.size").intType().defaultValue((Object)20).withDescription("The connection pool size.");
    public static final ConfigOption<Integer> CONNECT_MAX_RETRIES = ConfigOptions.key((String)"connect.max-retries").intType().defaultValue((Object)3).withDescription("The max retry times that the connector should retry to build MySQL database server connection.");
    public static final ConfigOption<String> SCAN_STARTUP_MODE = ConfigOptions.key((String)"scan.startup.mode").stringType().defaultValue((Object)"initial").withDescription("Optional startup mode for MySQL CDC consumer, valid enumerations are \"initial\", \"earliest-offset\", \"latest-offset\", \"timestamp\", \"specific-offset\" or \"snapshot\".");
    public static final ConfigOption<String> SCAN_STARTUP_SPECIFIC_OFFSET_FILE = ConfigOptions.key((String)"scan.startup.specific-offset.file").stringType().noDefaultValue().withDescription("Optional binlog file name used in case of \"specific-offset\" startup mode");
    public static final ConfigOption<Long> SCAN_STARTUP_SPECIFIC_OFFSET_POS = ConfigOptions.key((String)"scan.startup.specific-offset.pos").longType().noDefaultValue().withDescription("Optional binlog file position used in case of \"specific-offset\" startup mode");
    public static final ConfigOption<String> SCAN_STARTUP_SPECIFIC_OFFSET_GTID_SET = ConfigOptions.key((String)"scan.startup.specific-offset.gtid-set").stringType().noDefaultValue().withDescription("Optional GTID set used in case of \"specific-offset\" startup mode");
    public static final ConfigOption<Long> SCAN_STARTUP_SPECIFIC_OFFSET_SKIP_EVENTS = ConfigOptions.key((String)"scan.startup.specific-offset.skip-events").longType().noDefaultValue().withDescription("Optional number of events to skip after the specific starting offset");
    public static final ConfigOption<Long> SCAN_STARTUP_SPECIFIC_OFFSET_SKIP_ROWS = ConfigOptions.key((String)"scan.startup.specific-offset.skip-rows").longType().noDefaultValue().withDescription("Optional number of rows to skip after the specific offset");
    public static final ConfigOption<Long> SCAN_STARTUP_TIMESTAMP_MILLIS = ConfigOptions.key((String)"scan.startup.timestamp-millis").longType().noDefaultValue().withDescription("Optional timestamp used in case of \"timestamp\" startup mode");
    public static final ConfigOption<Duration> HEARTBEAT_INTERVAL = ConfigOptions.key((String)"heartbeat.interval").durationType().defaultValue((Object)Duration.ofSeconds(30L)).withDescription("Optional interval of sending heartbeat event for tracing the latest available binlog offsets");
    @Experimental
    public static final ConfigOption<Integer> CHUNK_META_GROUP_SIZE = ConfigOptions.key((String)"chunk-meta.group.size").intType().defaultValue((Object)1000).withDescription("The group size of chunk meta, if the meta size exceeds the group size, the meta will be divided into multiple groups.");
    @Experimental
    public static final ConfigOption<Double> CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND = ConfigOptions.key((String)"chunk-key.even-distribution.factor.upper-bound").doubleType().defaultValue((Object)1000.0).withFallbackKeys(new String[]{"split-key.even-distribution.factor.upper-bound"}).withDescription("The upper bound of chunk key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query MySQL for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
    @Experimental
    public static final ConfigOption<Double> CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND = ConfigOptions.key((String)"chunk-key.even-distribution.factor.lower-bound").doubleType().defaultValue((Object)0.05).withFallbackKeys(new String[]{"split-key.even-distribution.factor.lower-bound"}).withDescription("The lower bound of chunk key distribution factor. The distribution factor is used to determine whether the table is evenly distribution or not. The table chunks would use evenly calculation optimization when the data distribution is even, and the query MySQL for splitting would happen when it is uneven. The distribution factor could be calculated by (MAX(id) - MIN(id) + 1) / rowCount.");
    @Experimental
    public static final ConfigOption<String> SCAN_INCREMENTAL_SNAPSHOT_CHUNK_KEY_COLUMN = ConfigOptions.key((String)"scan.incremental.snapshot.chunk.key-column").stringType().noDefaultValue().withDescription("The chunk key of table snapshot, captured tables are split into multiple chunks by a chunk key when read the snapshot of table.By default, the chunk key is the first column of the primary key.eg. db1.user_table_[0-9]+:col1;db[1-2].[app|web]_order_\\.*:col2;");
    @Experimental
    public static final ConfigOption<Boolean> SCAN_INCREMENTAL_CLOSE_IDLE_READER_ENABLED = ConfigOptions.key((String)"scan.incremental.close-idle-reader.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to close idle readers at the end of the snapshot phase. This feature depends on FLIP-147: Support Checkpoints After Tasks Finished. The flink version is required to be greater than or equal to 1.14 when enabling this feature.");
    @Experimental
    public static final ConfigOption<Boolean> SCAN_NEWLY_ADDED_TABLE_ENABLED = ConfigOptions.key((String)"scan.newly-added-table.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to scan the newly added tables or not, by default is false. This option is only useful when we start the job from a savepoint/checkpoint.");
    @Experimental
    public static final ConfigOption<Boolean> SCHEMA_CHANGE_ENABLED = ConfigOptions.key((String)"schema-change.enabled").booleanType().defaultValue((Object)true).withDescription("Whether send schema change events, by default is true. If set to false, the schema changes will not be sent.");
    @Experimental
    public static final ConfigOption<String> TABLES_EXCLUDE = ConfigOptions.key((String)"tables.exclude").stringType().noDefaultValue().withDescription("Table names of the MySQL tables to Exclude. Regular expressions are supported. It is important to note that the dot (.) is treated as a delimiter for database and table names. If there is a need to use a dot (.) in a regular expression to match any character, it is necessary to escape the dot with a backslash.eg. db0.\\.*, db1.user_table_[0-9]+, db[1-2].[app|web]_order_\\.*");
    @Experimental
    public static final ConfigOption<Boolean> SCAN_BINLOG_NEWLY_ADDED_TABLE_ENABLED = ConfigOptions.key((String)"scan.binlog.newly-added-table.enabled").booleanType().defaultValue((Object)false).withDescription("In binlog reading stage, whether to scan the ddl and dml statements of newly added tables or not, by default is false. \nThe difference between scan.newly-added-table.enabled and scan.binlog.newly-added-table.enabled options is: \nscan.newly-added-table.enabled: do re-snapshot & binlog-reading for newly added table when restored; \nscan.binlog.newly-added-table.enabled: only do binlog-reading for newly added table during binlog reading phase.");
    @Experimental
    public static final ConfigOption<String> METADATA_LIST = ConfigOptions.key((String)"metadata.list").stringType().noDefaultValue().withDescription("List of readable metadata from SourceRecord to be passed to downstream, split by `,`. Available readable metadata are: op_ts.");
    @Experimental
    public static final ConfigOption<Boolean> PARSE_ONLINE_SCHEMA_CHANGES = ConfigOptions.key((String)"scan.parse.online.schema.changes.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to parse schema change events generated by gh-ost/pt-osc utilities. Defaults to false.");
    @Experimental
    public static final ConfigOption<Boolean> INCLUDE_COMMENTS_ENABLED = ConfigOptions.key((String)"include-comments.enabled").booleanType().defaultValue((Object)false).withDescription("Whether enable include table and column comments, by default is false, if set to true, table and column comments will be sent. Note: Enable this option will bring the implications on memory usage.");
    @Experimental
    public static final ConfigOption<Boolean> TREAT_TINYINT1_AS_BOOLEAN_ENABLED = ConfigOptions.key((String)"treat-tinyint1-as-boolean.enabled").booleanType().defaultValue((Object)true).withDescription("Whether treat TINYINT(1) as boolean, by default is true. ");
    @Experimental
    public static final ConfigOption<Boolean> USE_LEGACY_JSON_FORMAT = ConfigOptions.key((String)"use.legacy.json.format").booleanType().defaultValue((Object)true).withDescription("Whether to use legacy json format. The default value is true, which means there is no whitespace before value and after comma in json format.");
    @Experimental
    public static final ConfigOption<Boolean> SCAN_INCREMENTAL_SNAPSHOT_UNBOUNDED_CHUNK_FIRST_ENABLED = ConfigOptions.key((String)"scan.incremental.snapshot.unbounded-chunk-first.enabled").booleanType().defaultValue((Object)false).withDescription("Whether to assign the unbounded chunks first during snapshot reading phase. This might help reduce the risk of the TaskManager experiencing an out-of-memory (OOM) error when taking a snapshot of the largest unbounded chunk.  Defaults to false.");
}

