/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.relational.Column;
import io.debezium.relational.NoOpTableEditorImpl;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import java.util.List;
import java.util.stream.Collectors;

@NotThreadSafe
public interface TableEditor {
    public static TableEditor noOp(TableId id) {
        return new NoOpTableEditorImpl().tableId(id);
    }

    public TableId tableId();

    public TableEditor tableId(TableId var1);

    public List<Column> columns();

    default public List<String> columnNames() {
        return this.columns().stream().map(Column::name).collect(Collectors.toList());
    }

    public Column columnWithName(String var1);

    public List<String> primaryKeyColumnNames();

    default public boolean hasPrimaryKey() {
        return !this.primaryKeyColumnNames().isEmpty();
    }

    default public TableEditor addColumn(Column column) {
        return this.addColumns(column);
    }

    public TableEditor addColumns(Column ... var1);

    public TableEditor addColumns(Iterable<Column> var1);

    public TableEditor setColumns(Column ... var1);

    public TableEditor setColumns(Iterable<Column> var1);

    public TableEditor removeColumn(String var1);

    public TableEditor updateColumn(Column var1);

    public TableEditor reorderColumn(String var1, String var2);

    public TableEditor renameColumn(String var1, String var2);

    public TableEditor setPrimaryKeyNames(String ... var1);

    public TableEditor setPrimaryKeyNames(List<String> var1);

    public TableEditor setUniqueValues();

    public TableEditor setDefaultCharsetName(String var1);

    public TableEditor setComment(String var1);

    public boolean hasDefaultCharsetName();

    public boolean hasComment();

    public boolean hasUniqueValues();

    public Table create();
}

