/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.legacy;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mysql.GtidSet;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.util.Strings;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlJdbcContext
implements AutoCloseable {
    protected static final String MYSQL_CONNECTION_URL = "jdbc:mysql://${hostname}:${port}/?useInformationSchema=true&nullCatalogMeansCurrent=false&useUnicode=true&characterEncoding=UTF-8&characterSetResults=UTF-8&zeroDateTimeBehavior=CONVERT_TO_NULL&connectTimeout=${connectTimeout}";
    protected static final String JDBC_PROPERTY_LEGACY_DATETIME = "useLegacyDatetimeCode";
    private static final String SQL_SHOW_SYSTEM_VARIABLES = "SHOW VARIABLES";
    private static final String SQL_SHOW_SYSTEM_VARIABLES_CHARACTER_SET = "SHOW VARIABLES WHERE Variable_name IN ('character_set_server','collation_server')";
    private static final String SQL_SHOW_SESSION_VARIABLE_SSL_VERSION = "SHOW SESSION STATUS LIKE 'Ssl_version'";
    protected static JdbcConnection.ConnectionFactory FACTORY = JdbcConnection.patternBasedFactory("jdbc:mysql://${hostname}:${port}/?useInformationSchema=true&nullCatalogMeansCurrent=false&useUnicode=true&characterEncoding=UTF-8&characterSetResults=UTF-8&zeroDateTimeBehavior=CONVERT_TO_NULL&connectTimeout=${connectTimeout}", JdbcConfiguration.PORT.withDefault(MySqlConnectorConfig.PORT.defaultValueAsString()));
    protected static final Logger logger = LoggerFactory.getLogger(MySqlJdbcContext.class);
    protected final Configuration config;
    protected final JdbcConnection jdbc;
    private final Map<String, String> originalSystemProperties = new HashMap<String, String>();

    public MySqlJdbcContext(MySqlConnectorConfig config) {
        String legacyDateTime;
        this.config = config.getConfig();
        boolean useSSL = this.sslModeEnabled();
        Configuration jdbcConfig = ((Configuration.Builder)((Configuration.Builder)this.config.filter(x -> !x.startsWith("database.history.") && !x.equals(MySqlConnectorConfig.DATABASE_HISTORY.name())).edit().withDefault(MySqlConnectorConfig.PORT, MySqlConnectorConfig.PORT.defaultValue())).withDefault("database.useCursorFetch", config.useCursorFetch())).build().subset("database.", true);
        Configuration.Builder jdbcConfigBuilder = jdbcConfig.edit().with("connectTimeout", Long.toString(config.getConnectionTimeout().toMillis())).with("sslMode", this.sslMode().getValue());
        if (useSSL) {
            if (!Strings.isNullOrBlank(this.sslTrustStore())) {
                jdbcConfigBuilder.with("trustCertificateKeyStoreUrl", "file:" + this.sslTrustStore());
            }
            if (this.sslTrustStorePassword() != null) {
                jdbcConfigBuilder.with("trustCertificateKeyStorePassword", String.valueOf(this.sslTrustStorePassword()));
            }
            if (!Strings.isNullOrBlank(this.sslKeyStore())) {
                jdbcConfigBuilder.with("clientCertificateKeyStoreUrl", "file:" + this.sslKeyStore());
            }
            if (this.sslKeyStorePassword() != null) {
                jdbcConfigBuilder.with("clientCertificateKeyStorePassword", String.valueOf(this.sslKeyStorePassword()));
            }
        }
        if ((legacyDateTime = jdbcConfig.getString(JDBC_PROPERTY_LEGACY_DATETIME)) == null) {
            jdbcConfigBuilder.with(JDBC_PROPERTY_LEGACY_DATETIME, "false");
        } else if ("true".equals(legacyDateTime)) {
            logger.warn("'{}' is set to 'true'. This setting is not recommended and can result in timezone issues.", (Object)JDBC_PROPERTY_LEGACY_DATETIME);
        }
        jdbcConfig = jdbcConfigBuilder.build();
        String driverClassName = jdbcConfig.getString(MySqlConnectorConfig.JDBC_DRIVER);
        this.jdbc = new JdbcConnection(JdbcConfiguration.adapt(jdbcConfig), JdbcConnection.patternBasedFactory(MYSQL_CONNECTION_URL, driverClassName, this.getClass().getClassLoader(), new Field[0]), "`", "`");
    }

    public Configuration config() {
        return this.config;
    }

    public JdbcConnection jdbc() {
        return this.jdbc;
    }

    public Logger logger() {
        return logger;
    }

    public String username() {
        return this.config.getString(MySqlConnectorConfig.USER);
    }

    public String password() {
        return this.config.getString(MySqlConnectorConfig.PASSWORD);
    }

    public String hostname() {
        return this.config.getString(MySqlConnectorConfig.HOSTNAME);
    }

    public int port() {
        return this.config.getInteger(MySqlConnectorConfig.PORT);
    }

    public MySqlConnectorConfig.SecureConnectionMode sslMode() {
        String mode = this.config.getString(MySqlConnectorConfig.SSL_MODE);
        return MySqlConnectorConfig.SecureConnectionMode.parse(mode);
    }

    public boolean sslModeEnabled() {
        return this.sslMode() != MySqlConnectorConfig.SecureConnectionMode.DISABLED;
    }

    public String sslKeyStore() {
        return this.config.getString(MySqlConnectorConfig.SSL_KEYSTORE);
    }

    public char[] sslKeyStorePassword() {
        String password = this.config.getString(MySqlConnectorConfig.SSL_KEYSTORE_PASSWORD);
        return Strings.isNullOrBlank(password) ? null : password.toCharArray();
    }

    public String sslTrustStore() {
        return this.config.getString(MySqlConnectorConfig.SSL_TRUSTSTORE);
    }

    public char[] sslTrustStorePassword() {
        String password = this.config.getString(MySqlConnectorConfig.SSL_TRUSTSTORE_PASSWORD);
        return Strings.isNullOrBlank(password) ? null : password.toCharArray();
    }

    public CommonConnectorConfig.EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode() {
        String mode = this.config.getString(CommonConnectorConfig.EVENT_PROCESSING_FAILURE_HANDLING_MODE);
        if (mode == null) {
            mode = this.config.getString(MySqlConnectorConfig.EVENT_DESERIALIZATION_FAILURE_HANDLING_MODE);
        }
        return CommonConnectorConfig.EventProcessingFailureHandlingMode.parse(mode);
    }

    public CommonConnectorConfig.EventProcessingFailureHandlingMode inconsistentSchemaHandlingMode() {
        String mode = this.config.getString(MySqlConnectorConfig.INCONSISTENT_SCHEMA_HANDLING_MODE);
        return CommonConnectorConfig.EventProcessingFailureHandlingMode.parse(mode);
    }

    public void shutdown() {
        try {
            this.jdbc.close();
        }
        catch (SQLException e) {
            logger.error("Unexpected error shutting down the database connection", (Throwable)e);
        }
        finally {
            this.originalSystemProperties.forEach((name, value) -> {
                if (value != null) {
                    System.setProperty(name, value);
                } else {
                    System.clearProperty(name);
                }
            });
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public boolean isGtidModeEnabled() {
        AtomicReference<String> mode = new AtomicReference<String>("off");
        try {
            this.jdbc().query("SHOW GLOBAL VARIABLES LIKE 'GTID_MODE'", rs -> {
                if (rs.next()) {
                    mode.set(rs.getString(2));
                }
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Unexpected error while connecting to MySQL and looking at GTID mode: ", e);
        }
        return !"OFF".equalsIgnoreCase(mode.get());
    }

    public String knownGtidSet() {
        AtomicReference gtidSetStr = new AtomicReference();
        try {
            this.jdbc.query("SHOW MASTER STATUS", rs -> {
                if (rs.next() && rs.getMetaData().getColumnCount() > 4) {
                    gtidSetStr.set(rs.getString(5));
                }
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Unexpected error while connecting to MySQL and looking at GTID mode: ", e);
        }
        String result = (String)gtidSetStr.get();
        return result != null ? result : "";
    }

    public GtidSet subtractGtidSet(GtidSet set1, GtidSet set2) {
        try {
            return this.jdbc.prepareQueryAndMap("SELECT GTID_SUBTRACT(?, ?)", ps -> {
                ps.setString(1, set1.toString());
                ps.setString(2, set2.toString());
            }, rs -> {
                if (rs.next()) {
                    return new GtidSet(rs.getString(1));
                }
                return new GtidSet("");
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Unexpected error while connecting to MySQL and looking at GTID mode: ", e);
        }
    }

    public GtidSet purgedGtidSet() {
        AtomicReference gtidSetStr = new AtomicReference();
        try {
            this.jdbc.query("SELECT @@global.gtid_purged", rs -> {
                if (rs.next() && rs.getMetaData().getColumnCount() > 0) {
                    gtidSetStr.set(rs.getString(1));
                }
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Unexpected error while connecting to MySQL and looking at gtid_purged variable: ", e);
        }
        String result = (String)gtidSetStr.get();
        if (result == null) {
            result = "";
        }
        return new GtidSet(result);
    }

    public boolean userHasPrivileges(String grantName) {
        AtomicBoolean result = new AtomicBoolean(false);
        try {
            this.jdbc.query("SHOW GRANTS FOR CURRENT_USER", rs -> {
                while (rs.next()) {
                    String grants = rs.getString(1);
                    logger.debug(grants);
                    if (grants == null) {
                        return;
                    }
                    if (!(grants = grants.toUpperCase()).contains("ALL") && !grants.contains(grantName.toUpperCase())) continue;
                    result.set(true);
                }
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Unexpected error while connecting to MySQL and looking at privileges for current user: ", e);
        }
        return result.get();
    }

    public String connectionString() {
        return this.jdbc.connectionString(MYSQL_CONNECTION_URL);
    }

    protected Map<String, String> readMySqlCharsetSystemVariables() {
        logger.debug("Reading MySQL charset-related system variables before parsing DDL history.");
        return this.querySystemVariables(SQL_SHOW_SYSTEM_VARIABLES_CHARACTER_SET);
    }

    public Map<String, String> readMySqlSystemVariables() {
        logger.debug("Reading MySQL system variables");
        return this.querySystemVariables(SQL_SHOW_SYSTEM_VARIABLES);
    }

    private Map<String, String> querySystemVariables(String statement) {
        HashMap<String, String> variables = new HashMap<String, String>();
        try {
            this.jdbc.connect().query(statement, rs -> {
                while (rs.next()) {
                    String varName = rs.getString(1);
                    String value = rs.getString(2);
                    if (varName == null || value == null) continue;
                    variables.put(varName, value);
                    logger.debug("\t{} = {}", (Object)Strings.pad(varName, 45, ' '), (Object)Strings.pad(value, 45, ' '));
                }
            });
        }
        catch (SQLException e) {
            throw new ConnectException("Error reading MySQL variables: " + e.getMessage(), e);
        }
        return variables;
    }

    protected Map<String, DatabaseLocales> readDatabaseCollations() {
        logger.debug("Reading default database charsets");
        try {
            return this.jdbc.connect().queryAndMap("SELECT schema_name, default_character_set_name, default_collation_name FROM information_schema.schemata", rs -> {
                HashMap<String, DatabaseLocales> charsets = new HashMap<String, DatabaseLocales>();
                while (rs.next()) {
                    String dbName = rs.getString(1);
                    String charset = rs.getString(2);
                    String collation = rs.getString(3);
                    if (dbName == null || charset == null && collation == null) continue;
                    charsets.put(dbName, new DatabaseLocales(charset, collation));
                    logger.debug("\t{} = {}, {}", new Object[]{Strings.pad(dbName, 45, ' '), Strings.pad(charset, 45, ' '), Strings.pad(collation, 45, ' ')});
                }
                return charsets;
            });
        }
        catch (SQLException e) {
            throw new DebeziumException("Error reading default database charsets: " + e.getMessage(), e);
        }
    }

    protected String setStatementFor(Map<String, String> variables) {
        StringBuilder sb = new StringBuilder("SET ");
        boolean first = true;
        ArrayList<String> varNames = new ArrayList<String>(variables.keySet());
        Collections.sort(varNames);
        for (String varName : varNames) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(varName).append("=");
            String value = variables.get(varName);
            if (value == null) {
                value = "";
            }
            if (value.contains(",") || value.contains(";")) {
                value = "'" + value + "'";
            }
            sb.append(value);
        }
        return sb.append(";").toString();
    }

    protected void setSystemProperty(String property, Field field, boolean showValueInError) {
        String value = this.config.getString(field);
        if (value != null) {
            value = value.trim();
            String existingValue = System.getProperty(property);
            if (existingValue == null) {
                String existing = System.setProperty(property, value);
                this.originalSystemProperties.put(property, existing);
            } else if (!(existingValue = existingValue.trim()).equalsIgnoreCase(value)) {
                String msg = "System or JVM property '" + property + "' is already defined, but the configuration property '" + field.name() + "' defines a different value";
                if (showValueInError) {
                    msg = "System or JVM property '" + property + "' is already defined as " + existingValue + ", but the configuration property '" + field.name() + "' defines a different value '" + value + "'";
                }
                throw new ConnectException(msg);
            }
        }
    }

    public String getSessionVariableForSslVersion() {
        String SSL_VERSION = "Ssl_version";
        logger.debug("Reading MySQL Session variable for Ssl Version");
        Map<String, String> sessionVariables = this.querySystemVariables(SQL_SHOW_SESSION_VARIABLE_SSL_VERSION);
        if (!sessionVariables.isEmpty() && sessionVariables.containsKey("Ssl_version")) {
            return sessionVariables.get("Ssl_version");
        }
        return null;
    }

    public static class DatabaseLocales {
        private final String charset;
        private final String collation;

        public DatabaseLocales(String charset, String collation) {
            this.charset = charset;
            this.collation = collation;
        }

        public void appendToDdlStatement(String dbName, StringBuilder ddl) {
            if (this.charset != null) {
                logger.debug("Setting default charset '{}' for database '{}'", (Object)this.charset, (Object)dbName);
                ddl.append(" CHARSET ").append(this.charset);
            } else {
                logger.info("Default database charset for '{}' not found", (Object)dbName);
            }
            if (this.collation != null) {
                logger.debug("Setting default collation '{}' for database '{}'", (Object)this.collation, (Object)dbName);
                ddl.append(" COLLATE ").append(this.collation);
            } else {
                logger.info("Default database collation for '{}' not found", (Object)dbName);
            }
        }
    }
}

