/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.util;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.helpers.IInterfaceHost;
import appeng.util.item.AEFluidStack;
import appeng.util.item.AEItemStack;
import com.asdflj.ae2thing.common.item.ItemPhial;
import com.asdflj.ae2thing.common.parts.PartThaumatoriumInterface;
import com.asdflj.ae2thing.common.tile.TileInfusionInterface;
import com.asdflj.ae2thing.util.Ae2ReflectClient;
import com.glodblock.github.client.gui.GuiDualInterface;
import com.glodblock.github.common.item.ItemFluidDrop;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.gui.IWidgetHost;
import thaumicenergistics.common.fluids.GaseousEssentia;
import thaumicenergistics.common.items.ItemCraftingAspect;

public class TheUtil {
    public static boolean isItemCraftingAspect(IAEItemStack item) {
        return item.getItem() instanceof ItemCraftingAspect;
    }

    public static boolean isGaseousEssentia(IAEFluidStack fluid) {
        if (fluid == null || fluid.getFluid() == null) {
            return false;
        }
        return fluid.getFluid() instanceof GaseousEssentia;
    }

    public static IAEFluidStack itemCraftingAspect2IAEFluidStack(IAEItemStack item) {
        Aspect aspect = ItemCraftingAspect.getAspect((ItemStack)item.getItemStack());
        GaseousEssentia gaseousEssentia = GaseousEssentia.getGasFromAspect((Aspect)aspect);
        AEFluidStack fs = AEFluidStack.create((Object)new FluidStack((Fluid)gaseousEssentia, 1));
        fs.setStackSize(item.getStackSize());
        return fs;
    }

    public static IAEItemStack itemCraftingAspect2FluidDrop(IAEItemStack item) {
        IAEFluidStack fs = TheUtil.itemCraftingAspect2IAEFluidStack(item);
        ItemStack displayStack = ItemFluidDrop.newDisplayStack((FluidStack)fs.getFluidStack());
        AEItemStack result = AEItemStack.create((ItemStack)displayStack);
        result.setStackSize(fs.getStackSize());
        return result;
    }

    public static String getGuiDualInterfaceDisplayName(String displayName, GuiDualInterface gui) {
        IInterfaceHost host = Ae2ReflectClient.getHost(gui);
        if (host instanceof TileInfusionInterface) {
            return I18n.func_135052_a((String)"ae2thing.gui.infusion_interface", (Object[])new Object[0]);
        }
        if (host instanceof PartThaumatoriumInterface) {
            return I18n.func_135052_a((String)"ae2thing.gui.part_thaumatorium_interface", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)displayName, (Object[])new Object[0]);
    }

    public static IAEItemStack itemCraftingAspect2ItemPhial(IAEItemStack item) {
        Aspect aspect = ItemCraftingAspect.getAspect((ItemStack)item.getItemStack());
        IAEFluidStack fs = ItemPhial.newEssentiaStack(aspect, item.getStackSize());
        return ItemPhial.newAeStack(fs);
    }

    public static IAEItemStack itemPhial2ItemCraftingAspect(IAEItemStack item) {
        Aspect aspect = ItemPhial.getAspect(item.getItemStack());
        AEItemStack is = AEItemStack.create((ItemStack)ItemCraftingAspect.createStackForAspect((Aspect)aspect, (int)1));
        is.setStackSize(item.getStackSize());
        return is;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isTerminal() {
        return Minecraft.func_71410_x().field_71462_r instanceof IWidgetHost;
    }

    public static IAEItemStack essentia2CraftingAspect(IAEFluidStack is) {
        if (!TheUtil.isGaseousEssentia(is)) {
            return null;
        }
        GaseousEssentia gas = (GaseousEssentia)is.getFluid();
        return AEItemStack.create((ItemStack)ItemCraftingAspect.createStackForAspect((Aspect)gas.getAspect(), (int)1));
    }

    public static boolean isSameAspect(IAEItemStack phial, IAEItemStack craftingAspect) {
        if (ItemPhial.isItemPhial(phial) && TheUtil.isItemCraftingAspect(craftingAspect)) {
            Aspect pa = ItemPhial.getAspect(phial.getItemStack());
            Aspect ca = ItemCraftingAspect.getAspect((ItemStack)craftingAspect.getItemStack());
            if (pa == null) {
                return false;
            }
            return pa.getTag().equals(ca.getTag());
        }
        return false;
    }
}

