/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.util;

import appeng.api.util.DimensionalCoord;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class StorageProvider {
    private DimensionalCoord coord;
    private int slot;

    private StorageProvider(DimensionalCoord dimensionalCoord, int slot, ForgeDirection face) {
        this.coord = face != ForgeDirection.UNKNOWN ? StorageProvider.offset(dimensionalCoord, face) : dimensionalCoord;
        this.slot = slot;
    }

    public static DimensionalCoord offset(DimensionalCoord d, ForgeDirection face) {
        return new DimensionalCoord(d.getWorld(), d.x + face.offsetX, d.y + face.offsetY, d.z + face.offsetZ);
    }

    public StorageProvider(DimensionalCoord dimensionalCoord, ForgeDirection face) {
        this(dimensionalCoord, -1, face);
    }

    public StorageProvider(DimensionalCoord dimensionalCoord, int slot) {
        this(dimensionalCoord, slot, ForgeDirection.UNKNOWN);
    }

    public StorageProvider(int x, int y, int z, int dim, int slot) {
        this(new DimensionalCoord(x, y, z, dim), slot);
    }

    public int getSlot() {
        return this.slot;
    }

    public DimensionalCoord getCoord() {
        return this.coord;
    }

    public void writeToNBT(NBTTagCompound tag) {
        StorageProvider.writeToNBT(tag, this.coord.x, this.coord.y, this.coord.z, this.coord.getDimension(), this.slot);
    }

    private static void writeToNBT(NBTTagCompound data, int x, int y, int z, int dimId, int slot) {
        data.func_74768_a("dim", dimId);
        data.func_74768_a("x", x);
        data.func_74768_a("y", y);
        data.func_74768_a("z", z);
        data.func_74768_a("slot", slot);
    }

    public static void writeListToNBT(NBTTagCompound tag, List<StorageProvider> list) {
        int i = 0;
        for (StorageProvider d : list) {
            NBTTagCompound data = new NBTTagCompound();
            StorageProvider.writeToNBT(data, d.coord.x, d.coord.y, d.coord.z, d.coord.getDimension(), d.slot);
            tag.func_74782_a("pos#" + i, (NBTBase)data);
            ++i;
        }
    }

    public static StorageProvider readFromNBT(NBTTagCompound data) {
        return new StorageProvider(new DimensionalCoord(data.func_74762_e("x"), data.func_74762_e("y"), data.func_74762_e("z"), data.func_74762_e("dim")), data.func_74762_e("slot"));
    }

    public static List<StorageProvider> readAsListFromNBT(NBTTagCompound tag) {
        ArrayList<StorageProvider> list = new ArrayList<StorageProvider>();
        int i = 0;
        while (tag.func_74764_b("pos#" + i)) {
            NBTTagCompound data = tag.func_74775_l("pos#" + i);
            list.add(StorageProvider.readFromNBT(data));
            ++i;
        }
        return list;
    }
}

