/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.util;

import appeng.api.util.DimensionalCoord;
import appeng.container.AEBaseContainer;
import appeng.container.slot.SlotRestrictedInput;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.client.render.BlockPosHighlighter;
import com.asdflj.ae2thing.util.StorageProvider;
import com.gtnh.findit.FindIt;
import com.gtnh.findit.FindItConfig;
import com.gtnh.findit.FindItNetwork;
import com.gtnh.findit.fx.SlotHighlighter;
import com.gtnh.findit.service.itemfinder.FindItemRequest;
import com.gtnh.findit.util.AbstractStackFinder;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
public class FindITUtil
implements Runnable {
    private static SlotHighlighter slotHighlighter;
    private final List<StorageProvider> storageProviderList = new ArrayList<StorageProvider>();
    public static FindITUtil instance;
    private long expirationTime = 0L;

    @Override
    public void run() {
        for (IContainerInputHandler handler : GuiContainerManager.inputHandlers) {
            if (!(handler instanceof AbstractStackFinder) || !handler.getClass().getName().contains("ClientItemFindService")) continue;
            GuiContainerManager.inputHandlers.remove(handler);
            GuiContainerManager.inputHandlers.add(new ItemFindService());
            break;
        }
        for (IContainerInputHandler handler : GuiContainerManager.drawHandlers) {
            SlotHighlighter s;
            if (!(handler instanceof SlotHighlighter)) continue;
            slotHighlighter = s = (SlotHighlighter)handler;
            break;
        }
    }

    public void setSlotHighlighter(List<StorageProvider> storageProviderList, boolean closeGui) {
        this.storageProviderList.clear();
        this.storageProviderList.addAll(storageProviderList);
        this.expirationTime = System.currentTimeMillis() + (long)FindItConfig.ITEM_HIGHLIGHTING_DURATION * 1000L;
        List<DimensionalCoord> list = storageProviderList.stream().map(StorageProvider::getCoord).collect(Collectors.toList());
        BlockPosHighlighter.highlightBlocks((EntityPlayer)Minecraft.func_71410_x().field_71439_g, list, "ae2thing.nei.find_cell_item.highlight", "ae2thing.nei.find_cell_item.in_other_dim");
        if (Minecraft.func_71410_x().field_71462_r != null && closeGui) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
        }
    }

    public void highlighter() {
        Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (!(screen instanceof GuiContainer)) {
            return;
        }
        GuiContainer guiContainer = (GuiContainer)screen;
        if (!(container instanceof AEBaseContainer)) {
            return;
        }
        AEBaseContainer c = (AEBaseContainer)container;
        if (System.currentTimeMillis() > this.expirationTime) {
            this.storageProviderList.clear();
        }
        if (this.storageProviderList.isEmpty()) {
            return;
        }
        Object object = c.getTarget();
        if (object instanceof TileEntity) {
            TileEntity t = (TileEntity)object;
            HashSet<Slot> slots = this.getSlots(c, t);
            if (slots.isEmpty()) {
                return;
            }
            slotHighlighter.highlightSlots(guiContainer, slots, FindItConfig.ITEM_HIGHLIGHTING_COLOR);
        }
    }

    @NotNull
    private HashSet<Slot> getSlots(AEBaseContainer c, TileEntity t) {
        HashSet<Slot> slots = new HashSet<Slot>();
        for (StorageProvider storageProvider : this.storageProviderList) {
            if (!storageProvider.getCoord().equals((Object)new DimensionalCoord(t)) || storageProvider.getSlot() == -1) continue;
            for (int i = 0; i < c.field_75151_b.size(); ++i) {
                SlotRestrictedInput si;
                Slot s = (Slot)c.field_75151_b.get(i);
                if (!(s instanceof SlotRestrictedInput) || (si = (SlotRestrictedInput)s).getSlotIndex() != storageProvider.getSlot()) continue;
                slots.add(s);
            }
        }
        return slots;
    }

    static {
        instance = new FindITUtil();
    }

    private static class ItemFindService
    extends AbstractStackFinder {
        private ItemFindService() {
        }

        protected String getKeyBindId() {
            return FindIt.isExtraUtilitiesLoaded() ? "gui.xu_ping" : "gui.findit.find_item";
        }

        protected boolean findStack(ItemStack stack) {
            if (Minecraft.func_71410_x().field_71439_g.field_71070_bA instanceof AEBaseContainer) {
                AE2ThingAPI.instance().findCellItem(stack);
            } else {
                FindItNetwork.CHANNEL.sendToServer((IMessage)new FindItemRequest(stack));
            }
            return true;
        }
    }
}

