/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.network;

import appeng.container.implementations.ContainerCraftConfirm;
import com.asdflj.ae2thing.client.gui.container.ContainerWirelessConnectorTerminal;
import com.asdflj.ae2thing.client.gui.container.ContainerWirelessDualInterfaceTerminal;
import com.asdflj.ae2thing.client.gui.container.IPatternContainer;
import com.asdflj.ae2thing.client.gui.container.widget.IWidgetPatternContainer;
import com.asdflj.ae2thing.util.Util;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class CPacketTerminalBtns
implements IMessage {
    private String name = "";
    private String value;
    private NBTTagCompound tag;

    public CPacketTerminalBtns(String name, boolean value) {
        this(name, value ? 1 : 0);
    }

    public CPacketTerminalBtns(String name, Integer value) {
        this(name, value.toString(), null);
    }

    public CPacketTerminalBtns(String name, String value, NBTTagCompound tag) {
        this.name = name;
        this.value = value;
        this.tag = tag;
    }

    public CPacketTerminalBtns() {
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        int leName = buf.readInt();
        int leVal = buf.readInt();
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < leName; ++i) {
            sb.append(buf.readChar());
        }
        this.name = sb.toString();
        sb = new StringBuilder();
        for (i = 0; i < leVal; ++i) {
            sb.append(buf.readChar());
        }
        this.value = sb.toString();
        if (buf.readBoolean()) {
            try {
                ByteArrayInputStream bytes = new ByteArrayInputStream(buf.readBytes(buf.readableBytes()).array());
                this.tag = CompressedStreamTools.func_74796_a((InputStream)bytes);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        int i;
        buf.writeInt(this.name.length());
        buf.writeInt(this.value.length());
        for (i = 0; i < this.name.length(); ++i) {
            buf.writeChar((int)this.name.charAt(i));
        }
        for (i = 0; i < this.value.length(); ++i) {
            buf.writeChar((int)this.value.charAt(i));
        }
        buf.writeBoolean(this.tag != null);
        if (this.tag != null) {
            try {
                ByteBuf data = Unpooled.buffer();
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                DataOutputStream outputStream = new DataOutputStream(bytes);
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.tag, (OutputStream)outputStream);
                data.writeBytes(bytes.toByteArray());
                data.capacity(data.readableBytes());
                buf.writeBytes(data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class Handler
    implements IMessageHandler<CPacketTerminalBtns, IMessage> {
        public IMessage onMessage(CPacketTerminalBtns message, MessageContext ctx) {
            String name = message.name;
            String value = message.value;
            NBTTagCompound tag = message.tag;
            Container c = ctx.getServerHandler().field_147369_b.field_71070_bA;
            if (name.startsWith("PatternTerminal.") && c instanceof IWidgetPatternContainer) {
                IWidgetPatternContainer wpc = (IWidgetPatternContainer)c;
                IPatternContainer cpt = wpc.getContainer();
                switch (name) {
                    case "PatternTerminal.Encode": {
                        switch (value) {
                            case "0": {
                                cpt.encode();
                                break;
                            }
                            case "1": {
                                cpt.encodeAndMoveToInventory();
                                break;
                            }
                            case "3": {
                                cpt.encodeAllItemAndMoveToInventory();
                            }
                        }
                        break;
                    }
                    case "PatternTerminal.CraftMode": {
                        cpt.getPatternTerminal().setCraftingRecipe(value.equals("1"));
                        break;
                    }
                    case "PatternTerminal.Combine": {
                        cpt.getPatternTerminal().setCombineMode(value.equals("1"));
                        break;
                    }
                    case "PatternTerminal.Clear": {
                        cpt.clear();
                        break;
                    }
                    case "PatternTerminal.ActivePage": {
                        cpt.getPatternTerminal().setActivePage(Integer.parseInt(value));
                        break;
                    }
                    case "PatternTerminal.Double": {
                        cpt.doubleStacks(Integer.parseInt(value));
                        break;
                    }
                    case "PatternTerminal.Substitute": {
                        cpt.getPatternTerminal().setSubstitution(value.equals("1"));
                        break;
                    }
                    case "PatternTerminal.Prioritize": {
                        switch (value) {
                            case "0": 
                            case "1": {
                                cpt.getPatternTerminal().setPrioritization(value.equals("1"));
                                break;
                            }
                            case "2": {
                                cpt.getPatternTerminal().sortCraftingItems();
                            }
                        }
                        break;
                    }
                    case "PatternTerminal.Invert": {
                        cpt.getPatternTerminal().setInverted(value.equals("1"));
                        break;
                    }
                    case "PatternTerminal.beSubstitute": {
                        cpt.getPatternTerminal().setBeSubstitute(value.equals("1"));
                    }
                }
                cpt.getPatternTerminal().saveSettings();
            }
            if (name.startsWith("InterfaceTerminal.") && c instanceof ContainerWirelessDualInterfaceTerminal) {
                ContainerWirelessDualInterfaceTerminal ciw = (ContainerWirelessDualInterfaceTerminal)c;
                switch (name) {
                    case "InterfaceTerminal.Double": {
                        ciw.doubleStacks(Integer.parseInt(value), tag);
                        break;
                    }
                    case "InterfaceTerminal.SetStick": {
                        ciw.setStick(tag);
                        break;
                    }
                    case "InterfaceTerminal.PatternModifier": {
                        ciw.setModifier(Integer.parseInt(value), tag);
                    }
                }
            }
            if (name.startsWith("WirelessConnectorTerminal.") && c instanceof ContainerWirelessConnectorTerminal) {
                ContainerWirelessConnectorTerminal cwt = (ContainerWirelessConnectorTerminal)c;
                switch (name) {
                    case "WirelessConnectorTerminal.SetName": {
                        cwt.setName(value, tag);
                        break;
                    }
                    case "WirelessConnectorTerminal.Unbind": {
                        cwt.unBind(tag);
                        break;
                    }
                    case "WirelessConnectorTerminal.Bind": {
                        cwt.bind(tag);
                        break;
                    }
                    case "WirelessConnectorTerminal.Color": {
                        cwt.setColor(tag);
                    }
                }
            }
            if (name.startsWith("GuiCraftConfirm.replan") && c instanceof ContainerCraftConfirm) {
                ContainerCraftConfirm ccc = (ContainerCraftConfirm)c;
                Util.replan((EntityPlayer)ctx.getServerHandler().field_147369_b, ccc);
            }
            return null;
        }
    }
}

