/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.network;

import appeng.client.gui.AEBaseGui;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import appeng.container.interfaces.IInventorySlotAware;
import com.asdflj.ae2thing.inventory.InventoryHandler;
import com.asdflj.ae2thing.inventory.gui.GuiType;
import com.asdflj.ae2thing.util.BlockPos;
import com.asdflj.ae2thing.util.Util;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CPacketSwitchGuis
implements IMessage {
    private GuiType guiType;

    public CPacketSwitchGuis() {
    }

    public CPacketSwitchGuis(GuiType guiType) {
        this.guiType = guiType;
        AEBaseGui.setSwitchingGuis((boolean)true);
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.guiType = GuiType.getByOrdinal(byteBuf.readByte());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.guiType != null ? this.guiType.ordinal() : 0);
    }

    public static class Handler
    implements IMessageHandler<CPacketSwitchGuis, IMessage> {
        @Nullable
        public IMessage onMessage(CPacketSwitchGuis message, MessageContext ctx) {
            if (message.guiType == null) {
                return null;
            }
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container cont = player.field_71070_bA;
            World w = player.field_70170_p;
            if (message.guiType == GuiType.BACKPACK_TERMINAL) {
                int s = Util.findBackPackTerminal((EntityPlayer)player);
                if (s != -1) {
                    InventoryHandler.openGui((EntityPlayer)player, w, new BlockPos(s, 0, 0), ForgeDirection.UNKNOWN, message.guiType);
                }
                return null;
            }
            if (message.guiType == GuiType.WIRELESS_DUAL_INTERFACE_TERMINAL) {
                int s = Util.findDualInterfaceTerminal((EntityPlayer)player);
                if (s != -1) {
                    InventoryHandler.openGui((EntityPlayer)player, w, new BlockPos(s, 0, 0), ForgeDirection.UNKNOWN, message.guiType);
                }
                return null;
            }
            if (message.guiType == GuiType.TERMINAL_MENU) {
                InventoryHandler.openGui((EntityPlayer)player, w, new BlockPos(0, 0, 0), ForgeDirection.UNKNOWN, message.guiType);
                return null;
            }
            if (message.guiType == GuiType.PATTERN_MODIFIER) {
                InventoryHandler.openGui((EntityPlayer)player, w, new BlockPos(player.field_71071_by.field_70461_c, 0, 0), ForgeDirection.UNKNOWN, message.guiType);
                return null;
            }
            if (cont instanceof AEBaseContainer) {
                AEBaseContainer c = (AEBaseContainer)cont;
                ContainerOpenContext context = ((AEBaseContainer)cont).getOpenContext();
                if (context == null) {
                    return null;
                }
                TileEntity te = context.getTile();
                if (te != null) {
                    InventoryHandler.openGui((EntityPlayer)player, player.field_70170_p, new BlockPos(te), Objects.requireNonNull(context.getSide()), message.guiType);
                } else {
                    InventoryHandler.openGui((EntityPlayer)player, player.func_130014_f_(), new BlockPos(((IInventorySlotAware)c.getTarget()).getInventorySlot(), 0, 0), Objects.requireNonNull(context.getSide()), message.guiType);
                }
            }
            return null;
        }
    }
}

