/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.network;

import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.api.adapter.terminal.item.ITerminalHandler;
import com.asdflj.ae2thing.api.adapter.terminal.item.TerminalItems;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class CPacketOpenTerminal
implements IMessage {
    private TerminalItems terminalItems;

    public CPacketOpenTerminal() {
    }

    public CPacketOpenTerminal(TerminalItems terminal) {
        this.terminalItems = terminal;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            ByteArrayInputStream bytes = new ByteArrayInputStream(buf.array());
            bytes.skip(1L);
            NBTTagCompound comp = CompressedStreamTools.func_74796_a((InputStream)bytes);
            if (comp != null) {
                this.terminalItems = TerminalItems.readFromNBT(comp);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void toBytes(ByteBuf buf) {
        try {
            NBTTagCompound tag = new NBTTagCompound();
            this.terminalItems.writeNBT(tag);
            ByteBuf data = Unpooled.buffer();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            DataOutputStream outputStream = new DataOutputStream(bytes);
            CompressedStreamTools.func_74799_a((NBTTagCompound)tag, (OutputStream)outputStream);
            data.writeBytes(bytes.toByteArray());
            data.capacity(data.readableBytes());
            buf.writeBytes(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static class Handler
    implements IMessageHandler<CPacketOpenTerminal, IMessage> {
        @Nullable
        public IMessage onMessage(CPacketOpenTerminal message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack item = message.terminalItems.getRawItem();
            if (item == null || item.func_77973_b() == null) {
                return null;
            }
            ITerminalHandler terminal = AE2ThingAPI.instance().terminal().getOpenTerminalHandler(item.func_77973_b().getClass());
            if (terminal == null) {
                return null;
            }
            if (terminal.canConnect(message.terminalItems.getRawItem(), terminal, message.terminalItems, player)) {
                terminal.openGui(message.terminalItems.getRawItem(), terminal, message.terminalItems, player);
            }
            return null;
        }
    }
}

