/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.network;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.AEBaseContainer;
import appeng.container.ContainerOpenContext;
import appeng.container.implementations.ContainerCraftAmount;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.helpers.InventoryAction;
import appeng.util.item.AEItemStack;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.client.gui.container.ContainerCraftingTerminal;
import com.asdflj.ae2thing.client.gui.container.ContainerPatternValueAmount;
import com.asdflj.ae2thing.inventory.InventoryHandler;
import com.asdflj.ae2thing.inventory.gui.GuiType;
import com.asdflj.ae2thing.inventory.item.WirelessTerminal;
import com.asdflj.ae2thing.network.SPacketSetItemAmount;
import com.asdflj.ae2thing.util.BlockPos;
import com.asdflj.ae2thing.util.ModAndClassUtil;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.crossmod.thaumcraft.AspectUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.common.items.ItemCraftingAspect;

public class CPacketInventoryAction
implements IMessage {
    private InventoryAction action;
    private int slot;
    private long id;
    private IAEItemStack stack;
    private boolean isEmpty;

    public CPacketInventoryAction() {
    }

    public CPacketInventoryAction(InventoryAction action, int slot, int id) {
        this.action = action;
        this.slot = slot;
        this.id = id;
        this.stack = null;
        this.isEmpty = true;
    }

    public CPacketInventoryAction(InventoryAction action, int slot, int id, IAEItemStack stack) {
        this.action = action;
        this.slot = slot;
        this.id = id;
        this.stack = stack;
        this.isEmpty = stack == null;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.slot);
        buf.writeLong(this.id);
        buf.writeBoolean(this.isEmpty);
        if (!this.isEmpty) {
            try {
                this.stack.writeToPacket(buf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.action = InventoryAction.values()[buf.readInt()];
        this.slot = buf.readInt();
        this.id = buf.readLong();
        this.isEmpty = buf.readBoolean();
        if (!this.isEmpty) {
            try {
                this.stack = AEItemStack.loadItemStackFromPacket((ByteBuf)buf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Handler
    implements IMessageHandler<CPacketInventoryAction, IMessage> {
        @Nullable
        public IMessage onMessage(CPacketInventoryAction message, MessageContext ctx) {
            EntityPlayerMP sender = ctx.getServerHandler().field_147369_b;
            if (sender.field_71070_bA instanceof ContainerCraftingTerminal) {
                return null;
            }
            Container container = sender.field_71070_bA;
            if (container instanceof AEBaseContainer) {
                AEBaseContainer baseContainer = (AEBaseContainer)container;
                Object target = baseContainer.getTarget();
                if (message.action == InventoryAction.AUTO_CRAFT) {
                    ContainerOpenContext context = baseContainer.getOpenContext();
                    if (context != null) {
                        Container is;
                        TileEntity te = context.getTile();
                        if (te != null || target instanceof WirelessTerminal) {
                            if (message.stack == null) {
                                message.stack = baseContainer.getTargetStack();
                            }
                            if (message.stack.getItem() instanceof ItemFluidDrop) {
                                IAEFluidStack fs = ItemFluidDrop.getAeFluidStack((IAEItemStack)message.stack);
                                if (ModAndClassUtil.THE && AspectUtil.isEssentiaGas((IAEFluidStack)fs)) {
                                    Aspect aspect = AspectUtil.getAspectFromGas((FluidStack)fs.getFluidStack());
                                    IAEItemStack result = AEApi.instance().storage().createItemStack(ItemCraftingAspect.createStackForAspect((Aspect)aspect, (int)1));
                                    baseContainer.setTargetStack(result);
                                } else {
                                    is = message.stack.getItemStack().func_77946_l();
                                    NBTTagCompound data = is.func_77978_p();
                                    data.func_82580_o("DisplayOnly");
                                    is.func_77982_d(data);
                                    baseContainer.setTargetStack((IAEItemStack)AEItemStack.create((ItemStack)is));
                                }
                            } else {
                                baseContainer.setTargetStack(message.stack);
                            }
                            if (te != null) {
                                InventoryHandler.openGui((EntityPlayer)sender, te.func_145831_w(), new BlockPos(te), Objects.requireNonNull(baseContainer.getOpenContext().getSide()), GuiType.CRAFTING_AMOUNT);
                            } else {
                                InventoryHandler.openGui((EntityPlayer)sender, sender.func_130014_f_(), new BlockPos(((WirelessTerminal)target).getInventorySlot(), 0, 0), Objects.requireNonNull(baseContainer.getOpenContext().getSide()), GuiType.CRAFTING_AMOUNT_ITEM);
                            }
                        }
                        if ((is = sender.field_71070_bA) instanceof ContainerCraftAmount) {
                            ContainerCraftAmount cca = (ContainerCraftAmount)is;
                            if (baseContainer.getTargetStack() != null) {
                                cca.getCraftingItem().func_75215_d(baseContainer.getTargetStack().getItemStack());
                                cca.setItemToCraft(baseContainer.getTargetStack());
                            }
                            cca.func_75142_b();
                        }
                    }
                } else if (message.action == InventoryAction.SET_PATTERN_VALUE) {
                    ContainerOpenContext context = baseContainer.getOpenContext();
                    if (context != null && message.stack != null) {
                        TileEntity te = context.getTile();
                        if (te != null) {
                            InventoryHandler.openGui((EntityPlayer)sender, te.func_145831_w(), new BlockPos(te), Objects.requireNonNull(baseContainer.getOpenContext().getSide()), GuiType.PATTERN_VALUE_SET);
                        } else {
                            InventoryHandler.openGui((EntityPlayer)sender, sender.func_130014_f_(), new BlockPos(((IInventorySlotAware)target).getInventorySlot(), 0, 0), Objects.requireNonNull(baseContainer.getOpenContext().getSide()), GuiType.PATTERN_VALUE_SET_ITEM);
                        }
                        int amt = (int)message.stack.getStackSize();
                        AE2Thing.proxy.netHandler.sendTo(new SPacketSetItemAmount(amt), sender);
                        Container container2 = sender.field_71070_bA;
                        if (container2 instanceof ContainerPatternValueAmount) {
                            ContainerPatternValueAmount cpv = (ContainerPatternValueAmount)container2;
                            if (baseContainer.getTargetStack() != null) {
                                cpv.setValueIndex(message.slot);
                                cpv.getPatternValue().func_75215_d(baseContainer.getTargetStack().getItemStack());
                            }
                            cpv.func_75142_b();
                        }
                    }
                } else {
                    baseContainer.doAction(sender, message.action, message.slot, message.id);
                }
            }
            return null;
        }
    }
}

