/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.nei;

import codechicken.lib.config.ConfigTagParent;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.api.API;
import codechicken.nei.api.IBookmarkContainerHandler;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.config.Option;
import com.asdflj.ae2thing.client.gui.GuiCraftingTerminal;
import com.asdflj.ae2thing.client.gui.GuiInfusionPatternTerminal;
import com.asdflj.ae2thing.client.gui.GuiWirelessDualInterfaceTerminal;
import com.asdflj.ae2thing.nei.AE2TH_NEIGuiHandler;
import com.asdflj.ae2thing.nei.BaseToggleButton;
import com.asdflj.ae2thing.nei.CraftingTransferHandler;
import com.asdflj.ae2thing.nei.PatternTerminalRecipeTransferHandler;
import com.asdflj.ae2thing.util.ModAndClassUtil;
import com.github.vfyjxf.nee.nei.NEETerminalBookmarkContainerHandler;
import com.glodblock.github.nei.recipes.FluidRecipe;
import java.util.ArrayList;

public class NEI_TH_Config
implements IConfigureNEI {
    private static final ConfigTagParent tag = NEIClientConfig.global.config;

    public void loadConfig() {
        API.registerNEIGuiHandler((INEIGuiHandler)new AE2TH_NEIGuiHandler());
        ArrayList<String> recipes = new ArrayList<String>();
        recipes.add("crafting");
        recipes.add("crafting2x2");
        for (String identifier : recipes) {
            if (API.hasGuiOverlayHandler(GuiCraftingTerminal.class, (String)identifier)) continue;
            API.registerGuiOverlayHandler(GuiCraftingTerminal.class, (IOverlayHandler)CraftingTransferHandler.INSTANCE, (String)identifier);
        }
        recipes.clear();
        recipes.add("infusionCrafting");
        recipes.add("cruciblerecipe");
        for (String identifier : recipes) {
            if (API.hasGuiOverlayHandler(GuiInfusionPatternTerminal.class, (String)identifier)) continue;
            API.registerGuiOverlayHandler(GuiInfusionPatternTerminal.class, (IOverlayHandler)PatternTerminalRecipeTransferHandler.INSTANCE, (String)identifier);
        }
        for (String identifier : FluidRecipe.getSupportRecipes()) {
            if (API.hasGuiOverlayHandler(GuiWirelessDualInterfaceTerminal.class, (String)identifier)) continue;
            API.registerGuiOverlayHandler(GuiWirelessDualInterfaceTerminal.class, (IOverlayHandler)PatternTerminalRecipeTransferHandler.INSTANCE, (String)identifier);
        }
        API.addOption((Option)new BaseToggleButton("ae2thing.history", false));
        API.addOption((Option)new BaseToggleButton("ae2thing.state"));
        API.addOption((Option)new BaseToggleButton("ae2thing.ultra_terminal_mode"));
        API.addOption((Option)new BaseToggleButton("ae2thing.dual_interface_terminal_fill_search_names", false));
        API.addOption((Option)new BaseToggleButton("ae2thing.crafting_notification"));
        API.addOption((Option)new BaseToggleButton("ae2thing.nei_craft_item"));
        if (ModAndClassUtil.PH) {
            API.addOption((Option)new BaseToggleButton("ae2thing.dual_interface_terminal_fill_circuit", false));
        }
        if (ModAndClassUtil.BLOCK_RENDER) {
            API.addOption((Option)new BaseToggleButton("ae2thing.block_render"));
        }
        if (ModAndClassUtil.NEE) {
            API.registerBookmarkContainerHandler(GuiWirelessDualInterfaceTerminal.class, (IBookmarkContainerHandler)NEETerminalBookmarkContainerHandler.instance);
        }
    }

    public static boolean getConfigValue(String identifier) {
        return tag.getTag(identifier).getBooleanValue(true);
    }

    public String getName() {
        return "AE2Thing";
    }

    public String getVersion() {
        return "v1.2.4";
    }
}

