/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.inventory.item;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.items.tools.powered.ToolWirelessTerminal;
import com.asdflj.ae2thing.api.WirelessObject;
import com.asdflj.ae2thing.inventory.item.INetworkTerminal;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public abstract class WirelessTerminal
implements ITerminalHost,
IInventorySlotAware,
IGuiItemObject,
IEnergySource,
INetworkTerminal,
IActionHost {
    protected final WirelessObject obj;
    protected final IAEItemPowerStorage ips;

    public WirelessTerminal(WirelessObject obj) {
        this.obj = obj;
        this.ips = (ToolWirelessTerminal)obj.getItemStack().func_77973_b();
        this.obj.setEnergySource(this);
    }

    public IGridNode getActionableNode() {
        return this.obj.getGridNode();
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        return this.obj.getGridNode();
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return this.obj.getCableConnectionType(dir);
    }

    public void securityBreak() {
        this.obj.securityBreak();
    }

    @Override
    public IGrid getGrid() {
        return this.obj.getGrid();
    }

    @Override
    public IGridNode getGridNode() {
        return this.obj.getGridNode();
    }

    public WirelessObject getWirelessObject() {
        return this.obj;
    }

    public ItemStack getItemStack() {
        return this.obj.getItemStack();
    }

    public int getInventorySlot() {
        return this.obj.getSlot();
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return this.obj.getItemInventory();
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        return this.obj.getFluidInventory();
    }

    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        amt = usePowerMultiplier.multiply(amt);
        if (mode == Actionable.SIMULATE) {
            return usePowerMultiplier.divide(Math.min(amt, this.ips.getAECurrentPower(this.getItemStack())));
        }
        return usePowerMultiplier.divide(this.ips.extractAEPower(this.getItemStack(), amt));
    }

    public BaseActionSource getActionSource() {
        return this.obj.getSource();
    }

    @NotNull
    public IAEStack<?> injectStack(IAEStack<?> stack, Actionable mode) {
        if (stack instanceof IAEItemStack) {
            return this.getItemInventory().injectItems((IAEStack)((IAEItemStack)stack), mode, this.getActionSource());
        }
        return this.getFluidInventory().injectItems((IAEStack)((IAEFluidStack)stack), mode, this.getActionSource());
    }

    @NotNull
    public IAEStack<?> extractStack(IAEStack<?> stack, Actionable mode) {
        if (stack instanceof IAEItemStack) {
            return this.getItemInventory().extractItems((IAEStack)((IAEItemStack)stack), mode, this.getActionSource());
        }
        return this.getFluidInventory().extractItems((IAEStack)((IAEFluidStack)stack), mode, this.getActionSource());
    }
}

