/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.inventory;

import appeng.core.AELog;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemBiggerAppEngInventory
extends AppEngInternalInventory {
    private final ItemStack is;
    private final String name;
    private final EntityPlayer player;
    private final int slot;
    private final IAEAppEngInventory terminal;
    private static final int MAX_SIZE = 64;

    public ItemBiggerAppEngInventory(ItemStack is, String name, int size, EntityPlayer player, int slot) {
        this(is, name, size, player, slot, null, 64);
    }

    public ItemBiggerAppEngInventory(ItemStack is, String name, int size, EntityPlayer player, int slot, IAEAppEngInventory terminal, int maxsize) {
        super(null, size, maxsize);
        this.name = name;
        this.is = is;
        this.player = player;
        this.slot = slot;
        this.terminal = terminal;
        this.readFromNBT(Platform.openNbtData((ItemStack)is), name);
        this.setMaxStackSize(maxsize);
    }

    public ItemBiggerAppEngInventory(ItemStack is, String name, int size, EntityPlayer player, int slot, IAEAppEngInventory terminal) {
        this(is, name, size, player, slot, terminal, 64);
    }

    protected void writeToNBT(NBTTagCompound target) {
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            try {
                NBTTagCompound c = new NBTTagCompound();
                if (this.inv[x] != null) {
                    Platform.writeItemStackToNBT((ItemStack)this.inv[x], (NBTTagCompound)c);
                }
                target.func_74782_a("#" + x, (NBTBase)c);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readFromNBT(NBTTagCompound target) {
        for (int x = 0; x < this.func_70302_i_(); ++x) {
            try {
                NBTTagCompound c = target.func_74775_l("#" + x);
                if (c == null) continue;
                this.inv[x] = Platform.loadItemStackFromNBT((NBTTagCompound)c);
                continue;
            }
            catch (Exception e) {
                AELog.debug((Throwable)e);
            }
        }
    }

    public void func_70296_d() {
        this.writeToNBT(Platform.openNbtData((ItemStack)this.is), this.name);
        if (Platform.isServer()) {
            if (this.slot != -1) {
                this.player.field_71071_by.func_70299_a(this.slot, this.is);
            } else {
                this.player.field_71071_by.func_70437_b(this.is);
            }
        }
    }

    public void markDirty(int slotIndex) {
        this.func_70296_d();
    }

    public void func_70299_a(int slot, ItemStack newItemStack) {
        ItemStack oldStack = this.inv[slot];
        this.inv[slot] = newItemStack;
        if (this.eventsEnabled() && this.terminal != null) {
            ItemStack removed = oldStack;
            ItemStack added = newItemStack;
            if (oldStack != null && newItemStack != null && Platform.isSameItemPrecise((ItemStack)oldStack, (ItemStack)newItemStack)) {
                if (oldStack.field_77994_a > newItemStack.field_77994_a) {
                    removed = removed.func_77946_l();
                    removed.field_77994_a -= newItemStack.field_77994_a;
                    added = null;
                } else if (oldStack.field_77994_a < newItemStack.field_77994_a) {
                    added = added.func_77946_l();
                    added.field_77994_a -= oldStack.field_77994_a;
                    removed = null;
                } else {
                    added = null;
                    removed = null;
                }
            }
            this.terminal.onChangeInventory((IInventory)this, slot, InvOperation.setInventorySlotContents, removed, added);
        }
        this.func_70296_d();
    }
}

