/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.crossmod.waila;

import appeng.api.AEApi;
import appeng.api.storage.ICellWorkbenchItem;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEItemStack;
import codechicken.lib.gui.GuiDraw;
import com.asdflj.ae2thing.client.render.RenderHelper;
import com.asdflj.ae2thing.common.item.ItemBackpackTerminal;
import com.asdflj.ae2thing.common.item.ItemInfinityStorageCell;
import com.asdflj.ae2thing.common.item.ItemInfinityStorageFluidCell;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import mcp.mobius.waila.handlers.nei.TooltipHandlerWaila;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CellContentHandler
extends TooltipHandlerWaila {
    public static HashSet<Class<? extends Item>> blackList = new HashSet();
    private static final List<IAEStack<?>> cellContent = new ArrayList();
    private static final List<IAEItemStack> upgradeCard = new ArrayList<IAEItemStack>();
    private static final int limit = 5;
    private static final int width = 100;
    private static final int height = 20;
    private static final GuiDraw.ITooltipLineHandler cellItemStackHandler = new GuiDraw.ITooltipLineHandler(){

        public Dimension getSize() {
            return new Dimension(100, 20);
        }

        public void draw(int x, int y) {
            if (!cellContent.isEmpty()) {
                for (int i = 0; i < cellContent.size() && i < 5; ++i) {
                    IAEStack item = (IAEStack)cellContent.get(i);
                    RenderHelper.renderAEStack(item, x + i * 18, y, 500.0f);
                }
                if (cellContent.size() > 5) {
                    Minecraft.func_71410_x().field_71466_p.func_78261_a("...", x + 90 + 1, y + 2, 0xFFFFFF);
                }
            }
        }
    };
    private static final GuiDraw.ITooltipLineHandler cellUpgradeCardHandler = new GuiDraw.ITooltipLineHandler(){

        public Dimension getSize() {
            return new Dimension(100, 20 + GuiDraw.fontRenderer.field_78288_b);
        }

        public void draw(int x, int y) {
            if (!upgradeCard.isEmpty()) {
                Minecraft.func_71410_x().field_71466_p.func_78261_a(I18n.func_135052_a((String)"ae2thing.tooltip.installed_card", (Object[])new Object[0]), x, y, 0xA8A8A8);
                for (int i = 0; i < upgradeCard.size() && i < 5; ++i) {
                    IAEStack item = (IAEStack)upgradeCard.get(i);
                    RenderHelper.renderAEStack(item, x + i * 18, y + GuiDraw.fontRenderer.field_78288_b, 500.0f, false);
                }
            }
        }
    };

    public List<String> handleItemTooltip(GuiContainer arg0, ItemStack cell, int x, int y, List<String> currentToolTip) {
        if (cell != null && AEApi.instance().registries().cell().isCellHandled(cell) && currentToolTip.size() >= 2 && cell.func_77973_b() != null && !blackList.contains(cell.func_77973_b().getClass())) {
            try {
                cellContent.clear();
                upgradeCard.clear();
                IMEInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(cell, null, StorageChannel.ITEMS);
                if (handler != null) {
                    IItemList itemList = handler.getAvailableItems(AEApi.instance().storage().createPrimitiveItemList(), 0);
                    List<IAEStack<?>> list = Arrays.stream((IAEItemStack[])itemList.toArray((IAEStack[])new IAEItemStack[0])).sorted(Comparator.comparingLong(IAEStack::getStackSize).reversed()).collect(Collectors.toList());
                    this.addTooltip(list, cell, currentToolTip);
                    return currentToolTip;
                }
                handler = AEApi.instance().registries().cell().getCellInventory(cell, null, StorageChannel.FLUIDS);
                if (handler != null) {
                    IItemList itemList = handler.getAvailableItems(AEApi.instance().storage().createFluidList(), 0);
                    List<IAEStack<?>> list = Arrays.stream((IAEFluidStack[])itemList.toArray((IAEStack[])new IAEFluidStack[0])).sorted(Comparator.comparingLong(IAEStack::getStackSize).reversed()).collect(Collectors.toList());
                    this.addTooltip(list, cell, currentToolTip);
                    return currentToolTip;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return currentToolTip;
    }

    private void addTooltip(List<IAEStack<?>> list, ItemStack cell, List<String> currentToolTip) {
        if (!list.isEmpty()) {
            cellContent.addAll(list);
            currentToolTip.add(currentToolTip.size() - 1, "\u00a7x" + GuiDraw.getTipLineId((GuiDraw.ITooltipLineHandler)cellItemStackHandler));
        }
        this.addUpgradeCard(cell, currentToolTip);
    }

    private void addUpgradeCard(ItemStack cell, List<String> currentToolTip) {
        Item item;
        if (cell != null && cell.func_77973_b() != null && (item = cell.func_77973_b()) instanceof ICellWorkbenchItem) {
            ICellWorkbenchItem workbenchItem = (ICellWorkbenchItem)item;
            IInventory inv = workbenchItem.getUpgradesInventory(cell);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack card = inv.func_70301_a(i);
                if (card == null) continue;
                upgradeCard.add((IAEItemStack)AEItemStack.create((ItemStack)card));
            }
            if (!upgradeCard.isEmpty()) {
                currentToolTip.add(currentToolTip.size() - 1, "\u00a7x" + GuiDraw.getTipLineId((GuiDraw.ITooltipLineHandler)cellUpgradeCardHandler));
            }
        }
    }

    static {
        blackList.add(ItemBackpackTerminal.class);
        blackList.add(ItemInfinityStorageCell.class);
        blackList.add(ItemInfinityStorageFluidCell.class);
    }
}

