/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.tile;

import appeng.api.storage.data.IAEFluidStack;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import com.asdflj.ae2thing.common.item.ItemPhial;
import com.asdflj.ae2thing.inventory.IEssentiaContainer;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.tile.TileFluidInterface;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.Thaumcraft;

public class TileInfusionInterface
extends TileFluidInterface
implements IAspectSource,
IEssentiaContainer,
IEssentiaTransport {
    private final AspectList aspects = new AspectList();

    @Override
    public AspectList getAspects() {
        return this.aspects;
    }

    public void getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        super.getDrops(w, x, y, z, drops);
        for (Aspect aspect : this.aspects.getAspectsSorted()) {
            int stored = this.aspects.getAmount(aspect);
            if (stored <= 0) continue;
            ItemStack fluidPacket = ItemFluidPacket.newStack((IAEFluidStack)ItemPhial.newEssentiaStack(aspect, stored));
            drops.add(fluidPacket);
        }
    }

    public void setAspects(AspectList var1) {
        this.aspects.add(var1);
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return this.aspects.getAmount(aspect) > 0;
    }

    public int addToContainer(Aspect aspect, int amount) {
        this.aspects.add(aspect, amount);
        return amount;
    }

    private void doParticalFX(int aspectColor) {
        int i;
        float red = (float)(aspectColor & 0xFF0000) / 1.671168E7f;
        float green = (float)(aspectColor & 0xFF00) / 65280.0f;
        float blue = (float)(aspectColor & 0xFF) / 255.0f;
        for (i = 0; i < 5; ++i) {
            Thaumcraft.proxy.blockRunes(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, red, green, blue, 15, -0.1f);
        }
        for (i = 0; i < 5; ++i) {
            Thaumcraft.proxy.blockRunes(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, red, green, blue, 15, 0.1f);
        }
    }

    public boolean takeFromContainer(Aspect aspect, int amount) {
        int stored = this.aspects.getAmount(aspect);
        if (stored >= amount) {
            this.aspects.remove(aspect, amount);
            this.doParticalFX(aspect.getColor());
            return true;
        }
        return false;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBTEvent(NBTTagCompound data) {
        super.readFromNBTEvent(data);
        this.aspects.readFromNBT(data);
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public NBTTagCompound writeToNBTEvent(NBTTagCompound data) {
        super.writeToNBTEvent(data);
        this.aspects.writeToNBT(data);
        return data;
    }

    public boolean takeFromContainer(AspectList var1) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect var1, int var2) {
        return this.aspects.getAmount(var1) > 0;
    }

    public boolean doesContainerContain(AspectList var1) {
        return true;
    }

    public int containerContains(Aspect var1) {
        return this.aspects.getAmount(var1);
    }

    public boolean isConnectable(ForgeDirection side) {
        return false;
    }

    public boolean canInputFrom(ForgeDirection side) {
        return false;
    }

    public boolean canOutputTo(ForgeDirection side) {
        return true;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public Aspect getSuctionType(ForgeDirection var1) {
        return null;
    }

    public int getSuctionAmount(ForgeDirection side) {
        return 8;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection side) {
        int stored = this.aspects.getAmount(aspect);
        if (stored >= amount) {
            this.aspects.remove(aspect, amount);
            return amount;
        }
        return 0;
    }

    public int addEssentia(Aspect var1, int var2, ForgeDirection var3) {
        return 0;
    }

    public Aspect getEssentiaType(ForgeDirection side) {
        Aspect wantedAspect = this.getNeighborWantedAspect(side);
        if (wantedAspect != null && this.aspects.getAmount(wantedAspect) > 0) {
            return wantedAspect;
        }
        return null;
    }

    public int getEssentiaAmount(ForgeDirection side) {
        Aspect wantedAspect = this.getNeighborWantedAspect(side);
        if (wantedAspect != null) {
            return this.aspects.getAmount(wantedAspect);
        }
        return 0;
    }

    protected Aspect getNeighborWantedAspect(ForgeDirection side) {
        TileEntity neighbor = this.field_145850_b.func_147438_o(this.field_145851_c + side.offsetX, this.field_145848_d + side.offsetY, this.field_145849_e + side.offsetZ);
        if (neighbor instanceof IEssentiaTransport) {
            return ((IEssentiaTransport)neighbor).getSuctionType(side.getOpposite());
        }
        return null;
    }

    public int getMinimumSuction() {
        return 1;
    }

    public boolean renderExtendedTube() {
        return false;
    }
}

