/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.tile;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.item.AEFluidStack;
import com.asdflj.ae2thing.inventory.item.FakeAEInventory;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.util.Util;
import io.netty.buffer.ByteBuf;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class TileFluidPacketEncoder
extends AENetworkInvTile
implements IPowerChannelState,
IStackWatcherHost,
IAEAppEngInventory {
    private boolean isPowered = false;
    private final AppEngInternalAEInventory config = new AppEngInternalAEInventory((IAEAppEngInventory)this, 1);
    private final FakeAEInventory output = new FakeAEInventory(this, 1);
    private IStackWatcher myWatcher;
    private long value = 0L;
    private final MachineSource source = new MachineSource((IActionHost)this);

    public TileFluidPacketEncoder() {
        this.getProxy().setIdlePowerUsage(3.0);
        this.getProxy().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public long getReportingValue() {
        return this.value;
    }

    public void setReportingValue(long v) {
        this.value = v;
    }

    public void setFluidInSlot(Integer id, IAEFluidStack fluid) {
        ItemStack tmp = ItemFluidPacket.newDisplayStack((FluidStack)(fluid == null ? null : fluid.getFluidStack()));
        this.config.func_70299_a(id.intValue(), tmp);
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public boolean isActive() {
        return this.isPowered;
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    public boolean readFromStream(ByteBuf data) {
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void writeToStream(ByteBuf data) {
        data.writeBoolean(this.isActive());
    }

    @MENetworkEventSubscribe
    public void stateChange(MENetworkPowerStatusChange p) {
        this.updatePowerState();
    }

    @MENetworkEventSubscribe
    public void channelChanged(MENetworkChannelsChanged c) {
        this.updatePowerState();
    }

    private void updatePowerState() {
        boolean newState = false;
        try {
            newState = this.getProxy().isActive() && this.getProxy().getEnergy().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        if (newState != this.isPowered) {
            this.isPowered = newState;
            this.configureWatchers();
            this.markForUpdate();
        }
    }

    private IAEFluidStack getIAEFluidStack() {
        FluidStack fs = ItemFluidPacket.getFluidStack((IAEItemStack)this.config.getAEStackInSlot(0));
        if (fs != null) {
            return Util.FluidUtil.createAEFluidStack((FluidStack)fs);
        }
        return null;
    }

    public boolean dropItems() {
        return false;
    }

    public void configureWatchers() {
        if (!this.isActive()) {
            this.output.func_70299_a(0, null);
            return;
        }
        IAEFluidStack myStack = this.getIAEFluidStack();
        if (this.myWatcher != null) {
            this.myWatcher.clear();
        }
        if (this.myWatcher != null && myStack != null) {
            this.myWatcher.add((Object)myStack);
            this.updatePacketStack();
        } else {
            this.output.func_70299_a(0, null);
        }
    }

    public void updateWatcher(IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatchers();
    }

    public void onStackChange(IItemList o, IAEStack fullStack, IAEStack diffStack, BaseActionSource src, StorageChannel chan) {
        this.updatePacketStack();
    }

    private void updatePacketStack() {
        IAEFluidStack fs = this.getIAEFluidStack();
        if (fs == null || fs.getStackSize() == 0L || this.value <= 0L) {
            return;
        }
        fs.setStackSize(this.value);
        ItemStack is = ItemFluidPacket.newStack((IAEFluidStack)fs);
        if (is == null) {
            return;
        }
        try {
            IItemList storageList = this.getProxy().getStorage().getFluidInventory().getStorageList();
            IAEFluidStack stored = (IAEFluidStack)storageList.findPrecise((IAEStack)fs);
            if (stored == null) {
                this.output.setInventorySlotContentsNoCallBack(0, null);
                return;
            }
            is.field_77994_a = stored.getStackSize() / this.value > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)(stored.getStackSize() / this.value);
        }
        catch (Exception ignored) {
            is.field_77994_a = 0;
        }
        this.output.setInventorySlotContentsNoCallBack(0, is);
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.config) {
            this.configureWatchers();
        } else if (inv == this.output && removedStack != null && removedStack.field_77994_a > 0) {
            try {
                AEFluidStack fs = AEFluidStack.create((Object)ItemFluidPacket.getFluidStack((ItemStack)removedStack));
                if (fs != null) {
                    fs.setStackSize(fs.getStackSize() * (long)removedStack.field_77994_a);
                    this.getProxy().getStorage().getFluidInventory().extractItems((IAEStack)fs, Actionable.MODULATE, (BaseActionSource)this.source);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean func_102007_a(int slotIndex, ItemStack insertingItem, int side) {
        return false;
    }

    public int[] getAccessibleSlotsBySide(ForgeDirection whichSide) {
        return new int[]{0};
    }

    public boolean canBeRotated() {
        return false;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.SMART;
    }

    public IInventory getInternalInventory() {
        return this.output;
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("ConfigInv")) {
            return this.config;
        }
        return null;
    }

    public boolean func_102008_b(int slotIndex, ItemStack extractedItem, int side) {
        if (slotIndex == 0 && extractedItem != null && this.output.func_70301_a(0) != null && Platform.isSameItemPrecise((ItemStack)extractedItem, (ItemStack)this.output.func_70301_a(0))) {
            ItemStack is = this.output.func_70301_a(0);
            return is.field_77994_a >= extractedItem.field_77994_a;
        }
        return false;
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBTEvent(NBTTagCompound data) {
        this.value = data.func_74763_f("value");
        this.config.readFromNBT(data, "ConfigInv");
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public NBTTagCompound writeToNBTEvent(NBTTagCompound data) {
        data.func_74772_a("value", this.value);
        this.config.writeToNBT(data, "ConfigInv");
        return data;
    }
}

