/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.storage.infinityCell;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.exceptions.AppEngException;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.CellInventory;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.common.item.BaseCellItem;
import com.asdflj.ae2thing.common.item.ItemInfinityStorageCell;
import com.asdflj.ae2thing.common.storage.DataStorage;
import com.asdflj.ae2thing.common.storage.ITCellInventory;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class InfinityItemStorageCellInventory
implements ITCellInventory {
    private static final String ITEM_TYPE_TAG = "it";
    private static final String ITEM_COUNT_TAG = "ic";
    protected final ItemStack cellItem;
    protected ItemInfinityStorageCell cellType;
    protected final ISaveProvider container;
    protected final EntityPlayer player;
    protected IItemList<IAEItemStack> cellItems = null;
    protected long storedItemTypes;
    protected long storedItemCount = 0L;
    protected final NBTTagCompound data;
    protected final IChestOrDrive drive;
    protected final DataStorage storage;

    public InfinityItemStorageCellInventory(ItemStack o, ISaveProvider c, EntityPlayer p) throws AppEngException {
        if (o == null) {
            throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
        }
        this.cellItem = o;
        this.container = c;
        this.player = p;
        this.drive = c instanceof IChestOrDrive ? (IChestOrDrive)c : null;
        this.cellType = (ItemInfinityStorageCell)this.cellItem.func_77973_b();
        this.data = Platform.openNbtData((ItemStack)this.cellItem);
        this.storedItemTypes = this.data.func_74763_f(ITEM_TYPE_TAG);
        this.storedItemCount = this.data.func_74763_f(ITEM_COUNT_TAG);
        this.storage = this.getStorage();
    }

    @Override
    public double getIdleDrain(ItemStack is) {
        return this.cellType.getIdleDrain();
    }

    @Override
    public void loadCellItems() {
        if (this.cellItems == null) {
            this.cellItems = this.storage.getItems();
            for (IAEItemStack is : this.cellItems) {
                if (is.getStackSize() > 0L) continue;
                is.reset();
            }
        }
        if (!this.getUUID().equals(this.storage.getUUID())) {
            this.data.func_74778_a("diskuuid", this.storage.getUUID());
        }
    }

    protected IItemList<IAEItemStack> getCellItems() {
        if (this.cellItems == null) {
            this.loadCellItems();
        }
        return this.cellItems;
    }

    @Override
    public String getUUID() {
        if (this.data.func_82582_d()) {
            return "";
        }
        return this.data.func_74779_i("diskuuid");
    }

    @Override
    public ItemStack getItemStack() {
        return this.cellItem;
    }

    @Override
    public FuzzyMode getFuzzyMode() {
        return this.cellType.getFuzzyMode(this.cellItem);
    }

    @Override
    public IInventory getConfigInventory() {
        return this.cellType.getConfigInventory(this.cellItem);
    }

    @Override
    public IInventory getUpgradesInventory() {
        return this.cellType.getUpgradesInventory(this.cellItem);
    }

    @Override
    public int getBytesPerType() {
        return this.cellType.getBytesPerType(this.cellItem);
    }

    @Override
    public boolean canHoldNewItem(ItemStack is) {
        return true;
    }

    @Override
    public long getTotalBytes() {
        return this.cellType.getTotalTypes(this.cellItem);
    }

    @Override
    public long getFreeBytes() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getUsedBytes() {
        return 0L;
    }

    @Override
    public long getTotalItemTypes() {
        return this.cellType.getTotalTypes(this.cellItem);
    }

    @Override
    public long getStoredItemCount() {
        return this.storedItemCount;
    }

    @Override
    public long getStoredItemTypes() {
        return this.storedItemTypes;
    }

    @Override
    public long getRemainingItemTypes() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getRemainingItemCount() {
        return Long.MAX_VALUE;
    }

    @Override
    public int getUnusedItemCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getStatusForCell() {
        if (this.canHoldNewItem(this.cellItem)) {
            return 1;
        }
        if (this.getRemainingItemCount() > 0L) {
            return 2;
        }
        return 3;
    }

    @Override
    public String getOreFilter() {
        return this.cellType.getOreFilter(this.cellItem);
    }

    private static boolean isStorageCell(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        try {
            Item type = itemStack.func_77973_b();
            if (type instanceof IStorageCell) {
                return !((IStorageCell)type).storableInStorageCell();
            }
        }
        catch (Throwable err) {
            return true;
        }
        return false;
    }

    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, BaseActionSource src) {
        long remainingItemCount;
        IMEInventoryHandler meInventory;
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        if (this.cellType.isBlackListed(this.cellItem, input)) {
            return input;
        }
        ItemStack sharedItemStack = input.getItemStack();
        if (InfinityItemStorageCellInventory.isStorageCell(sharedItemStack) && (meInventory = CellInventory.getCell((ItemStack)sharedItemStack, null)) != null && !this.isEmpty((IMEInventory<IAEItemStack>)meInventory)) {
            return input;
        }
        IAEItemStack l = (IAEItemStack)this.getCellItems().findPrecise((IAEStack)input);
        if (l != null) {
            long remainingItemSlots = this.getRemainingItemCount();
            if (remainingItemSlots < 0L) {
                return input;
            }
            if (input.getStackSize() > remainingItemSlots) {
                IAEItemStack r = input.copy();
                r.setStackSize(r.getStackSize() - remainingItemSlots);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() + remainingItemSlots);
                    this.saveChanges();
                }
                return r;
            }
            if (mode == Actionable.MODULATE) {
                l.setStackSize(l.getStackSize() + input.getStackSize());
                this.saveChanges();
            }
            return null;
        }
        if (this.canHoldNewItem(this.cellItem) && (remainingItemCount = this.getRemainingItemCount() - (long)this.getBytesPerType() * 8L) > 0L) {
            if (input.getStackSize() > remainingItemCount) {
                AEItemStack toReturn = AEItemStack.create((ItemStack)sharedItemStack);
                toReturn.decStackSize(remainingItemCount);
                if (mode == Actionable.MODULATE) {
                    AEItemStack toWrite = AEItemStack.create((ItemStack)sharedItemStack);
                    toWrite.setStackSize(remainingItemCount);
                    this.cellItems.add((IAEStack)toWrite);
                    this.saveChanges();
                }
                return toReturn;
            }
            if (mode == Actionable.MODULATE) {
                this.cellItems.add((IAEStack)input);
                this.saveChanges();
            }
            return null;
        }
        return input;
    }

    private boolean isEmpty(IMEInventory<IAEItemStack> meInventory) {
        return meInventory.getAvailableItems(AEApi.instance().storage().createItemList()).isEmpty();
    }

    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        if (request == null) {
            return null;
        }
        long size = request.getStackSize();
        IAEItemStack results = null;
        IAEItemStack l = (IAEItemStack)this.getCellItems().findPrecise((IAEStack)request);
        if (l != null) {
            results = l.copy();
            if (l.getStackSize() <= size) {
                results.setStackSize(l.getStackSize());
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(0L);
                    this.saveChanges();
                }
            } else {
                results.setStackSize(size);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() - size);
                    this.saveChanges();
                }
            }
        }
        return results;
    }

    private void saveChanges() {
        this.data.func_74757_a("is_empty", this.cellItems.isEmpty());
        if (this.container != null) {
            this.container.saveChanges((IMEInventory)this);
        }
        AE2ThingAPI.instance().getStorageManager().postChanges(this.cellItem, this.storage, this.drive);
        AE2ThingAPI.instance().getStorageManager().func_76186_a(true);
    }

    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        AE2ThingAPI.instance().getStorageManager().addGrid(this.getUUID(), this.drive);
        for (IAEItemStack i : this.getCellItems()) {
            out.add((IAEStack)i);
        }
        return out;
    }

    public IAEItemStack getAvailableItem(@NotNull IAEItemStack request) {
        IAEItemStack is = (IAEItemStack)this.getCellItems().findPrecise((IAEStack)request);
        if (is != null) {
            return is.copy();
        }
        return null;
    }

    public StorageChannel getChannel() {
        return ((BaseCellItem)Objects.requireNonNull(this.cellItem.func_77973_b())).getChannel();
    }
}

