/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.storage;

import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.client.texture.ExtraBlockTextures;
import appeng.core.sync.GuiBridge;
import appeng.util.Platform;
import com.asdflj.ae2thing.common.item.IItemInventoryHandler;
import com.asdflj.ae2thing.common.storage.CellInventoryHandler;
import com.asdflj.ae2thing.common.storage.FluidCellInventoryHandler;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.util.BlockPos;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CellHandler
implements ICellHandler {
    public boolean isCell(ItemStack is) {
        return is != null && is.func_77973_b() instanceof IItemInventoryHandler;
    }

    public IMEInventoryHandler<?> getCellInventory(ItemStack is, ISaveProvider container, StorageChannel channel) {
        try {
            IItemInventoryHandler iih;
            Item item = is.func_77973_b();
            if (item instanceof IItemInventoryHandler && (iih = (IItemInventoryHandler)item).getChannel() == channel) {
                return iih.getInventoryHandler(is, container, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public IIcon getTopTexture_Light() {
        return ExtraBlockTextures.BlockMEChestItems_Light.getIcon();
    }

    public IIcon getTopTexture_Medium() {
        return ExtraBlockTextures.BlockMEChestItems_Medium.getIcon();
    }

    public IIcon getTopTexture_Dark() {
        return ExtraBlockTextures.BlockMEChestItems_Dark.getIcon();
    }

    public void openChestGui(EntityPlayer player, IChestOrDrive chest, ICellHandler cellHandler, IMEInventoryHandler inv, ItemStack is, StorageChannel chan) {
        if (chest instanceof TileEntity) {
            TileEntity te = (TileEntity)chest;
            if (chan == StorageChannel.FLUIDS) {
                InventoryHandler.openGui((EntityPlayer)player, (World)te.func_145831_w(), (BlockPos)new BlockPos(te), (ForgeDirection)chest.getUp(), (GuiType)GuiType.FLUID_TERMINAL);
            } else {
                Platform.openGUI((EntityPlayer)player, (TileEntity)te, (ForgeDirection)chest.getUp(), (GuiBridge)GuiBridge.GUI_ME);
            }
        }
    }

    public int getStatusForCell(ItemStack is, IMEInventory handler) {
        if (handler instanceof CellInventoryHandler) {
            CellInventoryHandler ci = (CellInventoryHandler)handler;
            return ci.getStatusForCell();
        }
        if (handler instanceof FluidCellInventoryHandler) {
            FluidCellInventoryHandler ci = (FluidCellInventoryHandler)handler;
            return ci.getStatusForCell();
        }
        return 0;
    }

    public double cellIdleDrain(ItemStack is, IMEInventory handler) {
        if (handler instanceof CellInventoryHandler) {
            CellInventoryHandler ci = (CellInventoryHandler)handler;
            return ci.getCellInv().getIdleDrain(is);
        }
        if (handler instanceof FluidCellInventoryHandler) {
            FluidCellInventoryHandler ci = (FluidCellInventoryHandler)handler;
            return ci.getCellInv().getIdleDrain(is);
        }
        return 0.0;
    }
}

