/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.parts;

import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.util.item.AEFluidStack;
import com.asdflj.ae2thing.common.item.ItemPhial;
import com.asdflj.ae2thing.inventory.IEssentiaContainer;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.parts.PartFluidInterface;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumicenergistics.api.tiles.IEssentiaTransportWithSimulate;
import thaumicenergistics.common.fluids.GaseousEssentia;

public class PartThaumatoriumInterface
extends PartFluidInterface
implements IEssentiaTransportWithSimulate,
IEssentiaContainer {
    private final AspectList aspects = new AspectList();
    private final MachineSource source = new MachineSource((IActionHost)this);

    public PartThaumatoriumInterface(ItemStack is) {
        super(is);
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (Aspect aspect : this.aspects.getAspectsSorted()) {
            int stored = this.aspects.getAmount(aspect);
            if (stored <= 0) continue;
            ItemStack fluidPacket = ItemFluidPacket.newStack((IAEFluidStack)ItemPhial.newEssentiaStack(aspect, stored));
            drops.add(fluidPacket);
        }
    }

    public int addEssentia(@NotNull Aspect aspect, int amount, @NotNull ForgeDirection side, @NotNull Actionable mode) {
        if (amount <= 0) {
            return 0;
        }
        try {
            IStorageGrid storageGrid = (IStorageGrid)this.getProxy().getGrid().getCache(IStorageGrid.class);
            AEFluidStack fs = AEFluidStack.create((Object)new FluidStack((Fluid)GaseousEssentia.getGasFromAspect((Aspect)aspect), amount));
            IAEFluidStack notInsertable = (IAEFluidStack)storageGrid.getFluidInventory().injectItems((IAEStack)fs, mode, (BaseActionSource)this.source);
            if (notInsertable == null) {
                return amount;
            }
            return (int)((long)amount - notInsertable.getStackSize());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean isConnectable(ForgeDirection side) {
        return true;
    }

    public boolean canInputFrom(ForgeDirection side) {
        return true;
    }

    public boolean canOutputTo(ForgeDirection side) {
        return true;
    }

    public void setSuction(Aspect aspect, int side) {
    }

    public Aspect getSuctionType(ForgeDirection side) {
        return null;
    }

    public int getSuctionAmount(ForgeDirection side) {
        return 8;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection side) {
        int stored = this.aspects.getAmount(aspect);
        if (stored >= amount) {
            this.aspects.remove(aspect, amount);
            return amount;
        }
        return 0;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection side) {
        return this.addEssentia(aspect, amount, side, Actionable.MODULATE);
    }

    public Aspect getEssentiaType(ForgeDirection side) {
        return null;
    }

    public int getEssentiaAmount(ForgeDirection side) {
        return 8;
    }

    public int getMinimumSuction() {
        return 1;
    }

    public boolean renderExtendedTube() {
        return false;
    }

    @Override
    public AspectList getAspects() {
        return this.aspects;
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.aspects.readFromNBT(data);
    }

    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.aspects.writeToNBT(data);
    }
}

