/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.item;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.exceptions.AppEngException;
import appeng.api.implementations.items.IItemGroup;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.util.Platform;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.common.item.BaseCellItem;
import com.asdflj.ae2thing.common.storage.CellInventoryHandler;
import com.asdflj.ae2thing.common.storage.ICellInventoryHandler;
import com.asdflj.ae2thing.common.storage.ITCellInventory;
import com.asdflj.ae2thing.common.storage.infinityCell.InfinityItemStorageCellInventory;
import com.asdflj.ae2thing.common.tabs.AE2ThingTabs;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemInfinityStorageCell
extends BaseCellItem
implements IStorageCell,
IItemGroup {
    private final int perType = 1;
    private final double idleDrain = 2000.0;

    public ItemInfinityStorageCell() {
        this.func_77625_d(1);
        this.func_77655_b("infinity_cell");
        this.func_111206_d(AE2Thing.resource("infinity_cell").toString());
        this.setFeature(EnumSet.of(AEFeature.StorageCells));
    }

    public String getUnlocalizedGroupName(Set<ItemStack> otherItems, ItemStack is) {
        return GuiText.StorageCells.getUnlocalized();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        ICellInventoryHandler handler;
        ITCellInventory cellInventory;
        IMEInventoryHandler inventory = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.ITEMS);
        if (inventory instanceof ICellInventoryHandler && (cellInventory = (handler = (ICellInventoryHandler)inventory).getCellInv()) != null) {
            String uid = cellInventory.getUUID();
            if (!uid.isEmpty()) {
                lines.add(uid);
            }
            if (handler.isPreformatted()) {
                String filter = cellInventory.getOreFilter();
                if (filter.isEmpty()) {
                    String list = (handler.getIncludeExcludeMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
                    if (handler.isFuzzy()) {
                        lines.add(GuiText.Partitioned.getLocal() + " - " + list + ' ' + GuiText.Fuzzy.getLocal());
                    } else {
                        lines.add(GuiText.Partitioned.getLocal() + " - " + list + ' ' + GuiText.Precise.getLocal());
                    }
                    if (GuiScreen.func_146272_n()) {
                        lines.add(GuiText.Filter.getLocal() + ": ");
                        for (int i = 0; i < cellInventory.getConfigInventory().func_70302_i_(); ++i) {
                            ItemStack s = cellInventory.getConfigInventory().func_70301_a(i);
                            if (s == null) continue;
                            lines.add(s.func_82833_r());
                        }
                    }
                } else {
                    lines.add(GuiText.PartitionedOre.getLocal() + " : " + filter);
                }
                if (handler.getSticky()) {
                    lines.add(GuiText.Sticky.getLocal());
                }
            }
        }
        super.addCheckedInformation(stack, player, lines, displayMoreInfo);
    }

    public int getBytes(ItemStack cellItem) {
        return Integer.MAX_VALUE;
    }

    public long getBytesLong(ItemStack cellItem) {
        return Integer.MAX_VALUE;
    }

    public int BytePerType(ItemStack cellItem) {
        return this.perType;
    }

    public int getBytesPerType(ItemStack cellItem) {
        return this.perType;
    }

    public int getTotalTypes(ItemStack cellItem) {
        return Integer.MAX_VALUE;
    }

    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requestedAddition) {
        return false;
    }

    public boolean storableInStorageCell() {
        return false;
    }

    public boolean isStorageCell(ItemStack i) {
        return false;
    }

    public double getIdleDrain() {
        return this.idleDrain;
    }

    public boolean isEditable(ItemStack is) {
        return true;
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        return FuzzyMode.fromItemStack((ItemStack)is);
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData((ItemStack)is).func_74778_a("FuzzyMode", fzMode.name());
    }

    public ItemInfinityStorageCell register() {
        GameRegistry.registerItem((Item)this, (String)"infinity_cell", (String)"ae2thing");
        this.func_77637_a(AE2ThingTabs.INSTANCE);
        return this;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    public IMEInventoryHandler<IAEItemStack> getInventoryHandler(ItemStack o, ISaveProvider container, EntityPlayer player) throws AppEngException {
        return new CellInventoryHandler(new InfinityItemStorageCellInventory(o, container, player));
    }
}

