/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.item;

import appeng.tile.networking.TileController;
import appeng.util.Platform;
import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.api.CraftingDebugCardObject;
import com.asdflj.ae2thing.api.CraftingDebugHelper;
import com.asdflj.ae2thing.common.item.BaseItem;
import com.asdflj.ae2thing.common.tabs.AE2ThingTabs;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ItemCraftingDebugCard
extends BaseItem {
    public ItemCraftingDebugCard() {
        this.func_77625_d(1);
        this.func_77655_b("crafting_debug_card");
        this.func_111206_d(AE2Thing.resource("crafting_debug_card").toString());
    }

    public ItemCraftingDebugCard register() {
        GameRegistry.registerItem((Item)this, (String)"crafting_debug_card", (String)"ae2thing");
        this.func_77637_a(AE2ThingTabs.INSTANCE);
        return this;
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (Platform.isServer() && (te = world.func_147438_o(x, y, z)) instanceof TileController) {
            TileController tc = (TileController)te;
            CraftingDebugCardObject obj = CraftingDebugHelper.getObject(itemstack);
            obj.sendRecordToPlayer(obj.getGrid(tc), player);
        }
        return super.onItemUseFirst(itemstack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public ItemStack func_77659_a(ItemStack item, World w, EntityPlayer player) {
        if (player.func_70093_af()) {
            CraftingDebugCardObject obj = CraftingDebugHelper.getObject(item);
            obj.setMode(obj.getNextMode());
            if (Platform.isClient()) {
                player.func_146105_b((IChatComponent)new ChatComponentText(I18n.func_135052_a((String)"ae2thing.crafting_debug_card.current_mode", (Object[])new Object[0]) + " " + this.getMode(obj)));
            }
        }
        return item;
    }

    private String getMode(CraftingDebugCardObject object) {
        String text;
        switch (object.getMode()) {
            case Player: {
                text = I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.request_type.player", (Object[])new Object[0]);
                break;
            }
            case Machine: {
                text = I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.request_type.machine", (Object[])new Object[0]);
                break;
            }
            default: {
                text = I18n.func_135052_a((String)"ae2thing.message.crafting_debug_card.request_type.everything", (Object[])new Object[0]);
            }
        }
        return text;
    }

    protected void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        CraftingDebugCardObject obj = CraftingDebugHelper.getObject(stack);
        lines.add(I18n.func_135052_a((String)"ae2thing.crafting_debug_card.current_mode", (Object[])new Object[0]) + " " + this.getMode(obj));
        if (GuiScreen.func_146272_n()) {
            lines.addAll(Arrays.asList(I18n.func_135052_a((String)"ae2thing.tooltip.crafting_debug_card.desc", (Object[])new Object[0]).split("\\\\n")));
        } else {
            lines.add(I18n.func_135052_a((String)"ae2thing.tooltip.shift_for_more", (Object[])new Object[0]));
        }
    }
}

