/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.item;

import appeng.api.AEApi;
import appeng.api.features.ILocatable;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.features.IWirelessTermRegistry;
import appeng.core.features.AEFeature;
import appeng.core.localization.PlayerMessages;
import appeng.items.tools.powered.ToolWirelessTerminal;
import appeng.util.Platform;
import baubles.api.IBauble;
import com.asdflj.ae2thing.client.gui.GuiWirelessConnectorTerminal;
import com.asdflj.ae2thing.client.me.WirelessConnectorRepo;
import com.asdflj.ae2thing.inventory.InventoryHandler;
import com.asdflj.ae2thing.inventory.gui.GuiType;
import com.asdflj.ae2thing.inventory.item.IItemInventory;
import com.asdflj.ae2thing.util.BlockPos;
import java.util.EnumSet;
import net.bdew.ae2stuff.machines.wireless.TileWireless;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class ItemBaseWirelessTerminal
extends ToolWirelessTerminal
implements IItemInventory,
IBauble {
    public ItemBaseWirelessTerminal() {
        this.setFeature(EnumSet.of(AEFeature.WirelessAccessTerminal, AEFeature.PoweredTools));
    }

    public ItemStack stack() {
        return new ItemStack((Item)this, 1);
    }

    public boolean canHandle(ItemStack is) {
        return is != null && is.func_77973_b() instanceof ItemBaseWirelessTerminal;
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return false;
    }

    public ItemStack func_77659_a(ItemStack item, World w, EntityPlayer player) {
        if (ForgeEventFactory.onItemUseStart((EntityPlayer)player, (ItemStack)item, (int)1) > 0) {
            if (Platform.isClient()) {
                return item;
            }
            IWirelessTermRegistry term = AEApi.instance().registries().wireless();
            if (!term.isWirelessTerminal(item)) {
                player.func_145747_a(PlayerMessages.DeviceNotWirelessTerminal.get());
                return item;
            }
            IWirelessTermHandler handler = term.getWirelessTerminalHandler(item);
            String unparsedKey = handler.getEncryptionKey(item);
            if (unparsedKey.isEmpty()) {
                player.func_145747_a(PlayerMessages.DeviceNotLinked.get());
                return item;
            }
            long parsedKey = Long.parseLong(unparsedKey);
            ILocatable securityStation = AEApi.instance().registries().locatable().getLocatableBy(parsedKey);
            if (securityStation == null) {
                player.func_145747_a(PlayerMessages.StationCanNotBeLocated.get());
                return item;
            }
            if (handler.hasPower(player, 0.5, item)) {
                InventoryHandler.openGui(player, w, new BlockPos(player.field_71071_by.field_70461_c, 0, 0), ForgeDirection.UNKNOWN, this.guiGuiType(item));
            } else {
                player.func_145747_a(PlayerMessages.DeviceNotPowered.get());
            }
        }
        return item;
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (Platform.isClient() && (te = world.func_147438_o(x, y, z)) instanceof TileWireless) {
            GuiWirelessConnectorTerminal.memoryText = String.format("%s%s,%s,%s", WirelessConnectorRepo.SearchMode.POS.getPrefix(), x, y, z);
        }
        return super.onItemUseFirst(itemstack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    protected abstract GuiType guiGuiType(ItemStack var1);
}

