/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.render;

import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.client.gui.AEBaseGui;
import appeng.client.me.SlotME;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.api.Pinned;
import com.asdflj.ae2thing.util.ModAndClassUtil;
import com.asdflj.ae2thing.util.Util;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.crossmod.thaumcraft.AspectRender;
import com.glodblock.github.crossmod.thaumcraft.AspectUtil;
import com.mitchej123.hodgepodge.textures.IPatchedTextureAtlasSprite;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;

public class RenderHelper {
    public static boolean canDrawPlus = false;
    private static Color color;
    private static long lastRunTime;
    public static long interval;
    public static RenderItem itemRender;

    public static void drawPinnedSlot(Slot slotIn, GuiScreen gui) {
        SlotME slotME;
        if (!AE2ThingAPI.instance().terminal().isPinTerminal(gui)) {
            return;
        }
        if (slotIn instanceof SlotME && (slotME = (SlotME)slotIn).func_75216_d()) {
            int x = slotIn.field_75223_e;
            int y = slotIn.field_75221_f;
            IAEItemStack item = ((SlotME)slotIn).getAEStack();
            if (!AE2ThingAPI.instance().getPinned().isPinnedItem(item)) {
                return;
            }
            Pinned.PinInfo info = AE2ThingAPI.instance().getPinned().getPinInfo(item);
            if (info != null && !info.canPrune) {
                RenderHelper.updateColorAndDrawItemBorder(x, y);
            }
        }
    }

    public static void renderAEStack(IAEStack<?> stack, int x, int y, float z) {
        RenderHelper.renderAEStack(stack, x, y, z, true);
    }

    public static void renderItemStack(ItemStack stack, int x, int y, float z) {
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        net.minecraft.client.renderer.RenderHelper.func_74520_c();
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)z);
        itemRender.func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), stack, x, y);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public static void renderAEStack(IAEStack<?> stack, int x, int y, float z, boolean renderStackSize) {
        if (stack instanceof IAEItemStack) {
            IAEItemStack itemStack = (IAEItemStack)stack;
            GL11.glPushAttrib((int)1048575);
            GL11.glPushMatrix();
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            GL11.glEnable((int)2929);
            GL11.glEnable((int)32826);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)z);
            itemRender.func_82406_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), itemStack.getItemStack(), x, y);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)150.0f);
            if (renderStackSize) {
                RenderHelper.drawStackSize(itemStack, x, y);
            }
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        } else if (stack instanceof IAEFluidStack) {
            IAEFluidStack fluidStack = (IAEFluidStack)stack;
            IAEItemStack fluidDrop = ItemFluidDrop.newAeStack((IAEFluidStack)fluidStack);
            if (fluidDrop == null) {
                return;
            }
            GL11.glPushAttrib((int)1048575);
            GL11.glPushMatrix();
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            GL11.glEnable((int)2929);
            GL11.glEnable((int)32826);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)z);
            if (ModAndClassUtil.THE && AspectUtil.isEssentiaGas((IAEFluidStack)fluidStack)) {
                GL11.glDisable((int)2929);
                AspectRender.drawAspect((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (int)x, (int)y, (float)z, (Aspect)AspectUtil.getAspectFromGas((FluidStack)fluidStack.getFluidStack()), (long)(fluidStack.getStackSize() <= 0L ? 1L : fluidStack.getStackSize()));
                IAEItemStack gas = (IAEItemStack)fluidDrop.copy().setStackSize(stack.getStackSize() / (long)AspectUtil.R);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)150.0f);
                if (renderStackSize) {
                    RenderHelper.drawStackSize(gas, x, y);
                }
            } else {
                RenderHelper.drawFluid(x, y, fluidStack.getFluid());
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)150.0f);
                if (renderStackSize) {
                    RenderHelper.drawStackSize(fluidDrop, x, y);
                }
            }
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }
    }

    private static void drawStackSize(IAEItemStack item, int x, int y) {
        AEBaseGui.aeRenderItem.setAeStack(item);
        AEBaseGui.aeRenderItem.func_77021_b(Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().func_110434_K(), item.getItemStack(), x, y);
    }

    private static void drawFluid(int posX, int posY, Fluid fluid) {
        if (fluid == null) {
            return;
        }
        IIcon icon = fluid.getIcon();
        if (icon == null) {
            return;
        }
        if (ModAndClassUtil.HODGEPODGE && icon instanceof IPatchedTextureAtlasSprite) {
            ((IPatchedTextureAtlasSprite)icon).markNeedsAnimationUpdate();
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)100.0f);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor3f((float)((float)(fluid.getColor() >> 16 & 0xFF) / 255.0f), (float)((float)(fluid.getColor() >> 8 & 0xFF) / 255.0f), (float)((float)(fluid.getColor() & 0xFF) / 255.0f));
        Minecraft.func_71410_x().field_71462_r.func_94065_a(posX, posY, fluid.getIcon(), 16, 16);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
    }

    public static void updateColor() {
        color = RenderHelper.getDynamicColor();
    }

    private static Color getDynamicColor() {
        long time = System.currentTimeMillis();
        if (time - lastRunTime >= interval || color == null) {
            lastRunTime = time;
            float hue = (float)(time % 2000L) / 2000.0f;
            Color c = Color.getHSBColor(hue, 1.0f, 1.0f);
            return new Color(c.getRed(), c.getGreen(), c.getBlue(), 128);
        }
        return color;
    }

    public static void drawItemBorder(int x, int y) {
        if (color == null) {
            return;
        }
        int width = 16;
        int height = 16;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)250.0f);
        Gui.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + width + 1), (int)y, (int)color.getRGB());
        Gui.func_73734_a((int)(x - 1), (int)(y + height + 1), (int)(x + width + 1), (int)(y + height), (int)color.getRGB());
        Gui.func_73734_a((int)(x - 1), (int)y, (int)x, (int)(y + height), (int)color.getRGB());
        Gui.func_73734_a((int)(x + width), (int)y, (int)(x + width + 1), (int)(y + height), (int)color.getRGB());
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-250.0f);
        GL11.glPopMatrix();
    }

    public static void updateColorAndDrawItemBorder(int x, int y) {
        RenderHelper.updateColor();
        RenderHelper.drawItemBorder(x, y);
    }

    public static void drawPlus(int x, int y) {
        float startX = (float)x + 0.5f;
        float startY = (float)y + 0.25f;
        float endX = startX + 3.0f;
        float endY = startY + 3.0f;
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)250.0f);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glLineWidth((float)3.0f);
        GL11.glBegin((int)1);
        GL11.glVertex2f((float)startX, (float)(startY + 1.5f));
        GL11.glVertex2f((float)endX, (float)(startY + 1.5f));
        GL11.glEnd();
        GL11.glBegin((int)1);
        GL11.glVertex2f((float)(startX + 1.5f), (float)startY);
        GL11.glVertex2f((float)(startX + 1.5f), (float)endY);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-250.0f);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public static void disableStandardItemLighting() {
        GL11.glDisable((int)2896);
        GL11.glDisable((int)16384);
        GL11.glDisable((int)16385);
        GL11.glDisable((int)2903);
    }

    private static void setCanDrawPlus() {
        canDrawPlus = Util.getAEVersion() < 536;
    }

    static {
        interval = 30L;
        itemRender = new RenderItem();
        RenderHelper.setCanDrawPlus();
    }
}

