/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.render;

import com.asdflj.ae2thing.AE2Thing;
import com.asdflj.ae2thing.client.render.RenderDollBlock;
import com.asdflj.ae2thing.common.block.BaseDollBlockContainer;
import com.asdflj.ae2thing.common.tile.TileDoll;
import cpw.mods.fml.client.registry.ClientRegistry;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class ItemDollRender
implements IItemRenderer {
    public static IModelCustom modelDoll = AdvancedModelLoader.loadModel((ResourceLocation)AE2Thing.resource("models/doll.obj"));
    public static HashMap<String, Resource> resources = new HashMap();
    private final String name;

    public ItemDollRender(BaseDollBlockContainer blockContainer) {
        this.name = blockContainer.name;
        ClientRegistry.bindTileEntitySpecialRenderer(TileDoll.class, (TileEntitySpecialRenderer)new RenderDollBlock(this));
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)blockContainer), (IItemRenderer)this);
        resources.put(this.name, new Resource(this.name));
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        boolean renderHair = true;
        GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
        GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        switch (type) {
            case EQUIPPED_FIRST_PERSON: {
                GL11.glTranslatef((float)-0.2f, (float)0.3f, (float)-0.4f);
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case INVENTORY: {
                renderHair = false;
                break;
            }
            default: {
                GL11.glTranslatef((float)0.0f, (float)0.7f, (float)-0.5f);
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
            }
        }
        this.render(renderHair, this.name);
        GL11.glPopMatrix();
    }

    public void render(boolean renderHair, String name) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resources.get(name).hair2);
        modelDoll.renderPart("hair2");
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resources.get(name).head);
        modelDoll.renderPart("head");
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resources.get(name).leg);
        modelDoll.renderPart("leg");
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resources.get(name).leg2);
        modelDoll.renderPart("leg2");
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resources.get(name).arm);
        modelDoll.renderPart("arm");
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resources.get(name).body);
        modelDoll.renderPart("body");
        Minecraft.func_71410_x().field_71446_o.func_110577_a(resources.get(name).button);
        modelDoll.renderPart("button");
        if (renderHair) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(resources.get(name).hair);
            modelDoll.renderPart("hair");
        }
    }

    public static class Resource {
        private final ResourceLocation leg;
        private final ResourceLocation leg2;
        private final ResourceLocation arm;
        private final ResourceLocation body;
        private final ResourceLocation button;
        private final ResourceLocation hair;
        private final ResourceLocation hair2;
        private final ResourceLocation head;

        public Resource(String name) {
            this.leg = new ResourceLocation("ae2thing", String.format("textures/blocks/%s/leg.png", name));
            this.leg2 = new ResourceLocation("ae2thing", String.format("textures/blocks/%s/leg2.png", name));
            this.arm = new ResourceLocation("ae2thing", String.format("textures/blocks/%s/arm.png", name));
            this.body = new ResourceLocation("ae2thing", String.format("textures/blocks/%s/body.png", name));
            this.button = new ResourceLocation("ae2thing", String.format("textures/blocks/%s/button.png", name));
            this.hair = new ResourceLocation("ae2thing", String.format("textures/blocks/%s/hair.png", name));
            this.hair2 = new ResourceLocation("ae2thing", String.format("textures/blocks/%s/hair2.png", name));
            this.head = new ResourceLocation("ae2thing", String.format("textures/blocks/%s/head.png", name));
        }
    }
}

