/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.me;

import appeng.api.util.DimensionalCoord;
import appeng.client.gui.widgets.IScrollSource;
import com.asdflj.ae2thing.client.gui.widget.Component;
import com.asdflj.ae2thing.client.me.IDisplayRepo;
import com.asdflj.ae2thing.util.Info;
import com.asdflj.ae2thing.util.NeCharUtil;
import com.asdflj.ae2thing.util.Util;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.annotations.NotNull;

public class WirelessConnectorRepo
implements IDisplayRepo {
    private final IScrollSource src;
    private final List<Info> infos = new ArrayList<Info>();
    private final List<Info> dsp = new ArrayList<Info>();
    private int rowSize = 9;
    private String searchString = "";

    public WirelessConnectorRepo(IScrollSource src) {
        this.src = src;
    }

    @Override
    public void postUpdate(Info info) {
        this.infos.add(info);
    }

    @Override
    public Info getInfo(int idx) {
        if ((idx += this.src.getCurrentScroll()) >= this.dsp.size()) {
            return null;
        }
        return this.dsp.get(idx);
    }

    @Override
    public void updateView() {
        if (Component.activeInfo != null) {
            boolean found = false;
            for (Info info : this.infos) {
                if (!Component.activeInfo.equals(info)) continue;
                found = true;
                break;
            }
            if (!found) {
                Component.activeInfo = null;
            }
        }
        this.dsp.clear();
        ArrayList tmp = new ArrayList();
        String innerSearch = this.searchString;
        this.dsp.addAll(this.infos);
        if (!innerSearch.isEmpty()) {
            String[] list;
            for (String s : list = innerSearch.split(" ")) {
                Pattern m;
                ImmutablePair<SearchMode, String> result = SearchMode.searchWhat(s);
                if (((String)result.right).isEmpty()) continue;
                try {
                    m = Pattern.compile(((String)result.right).toLowerCase(), 2);
                }
                catch (Throwable ignore) {
                    try {
                        m = Pattern.compile(Pattern.quote(((String)result.right).toLowerCase()), 2);
                    }
                    catch (Throwable __) {
                        return;
                    }
                }
                Pattern finalM = m;
                tmp.addAll(this.dsp.stream().filter(i -> NeCharUtil.INSTANCE.matcher(finalM, ((SearchMode)((Object)((Object)result.left))).getDisplayName((Info)i).toLowerCase())).collect(Collectors.toList()));
                this.dsp.clear();
                this.dsp.addAll(tmp);
                tmp.clear();
            }
        }
        this.dsp.sort(Comparator.comparing(Info::getName, String::compareToIgnoreCase));
        if (Component.activeInfo != null) {
            if (!this.dsp.contains(Component.activeInfo)) {
                this.dsp.add(0, Component.activeInfo);
            }
            if (Component.activeInfo.link) {
                DimensionalCoord b = Component.activeInfo.b;
                Optional<Info> info = this.infos.stream().filter(i -> i.a.equals((Object)b)).findFirst();
                if (info.isPresent() && !this.dsp.contains(info.get())) {
                    if (!this.dsp.isEmpty()) {
                        this.dsp.add(1, info.get());
                    } else {
                        this.dsp.add(0, info.get());
                    }
                }
            }
        }
    }

    @Override
    public int size() {
        return this.dsp.size();
    }

    @Override
    public void clear() {
        this.infos.clear();
    }

    @Override
    public int getRowSize() {
        return this.rowSize;
    }

    @Override
    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    @Override
    public String getSearchString() {
        return this.searchString;
    }

    @Override
    public void setSearchString(@NotNull String searchString) {
        this.searchString = searchString;
    }

    public static enum SearchMode {
        POS("#"),
        COLOR("~"),
        BIND("@b"),
        UNBIND("@u"),
        CLICKED("@c"),
        NAME("");

        private final String prefix;

        private SearchMode(String prefix) {
            this.prefix = prefix;
        }

        public String getDisplayName(Info info) {
            if (this == NAME) {
                return info.getName();
            }
            if (this == POS) {
                return info.getPosString();
            }
            if (this == COLOR) {
                return info.getColor();
            }
            if (this == BIND && info.link || this == UNBIND && !info.link) {
                return this.prefix;
            }
            if (this == CLICKED && Component.activeInfo != null && (Util.isSameDimensionalCoord(Component.activeInfo.a, info.a) || Component.activeInfo.link && Util.isSameDimensionalCoord(Component.activeInfo.b, info.a))) {
                return this.prefix;
            }
            return "";
        }

        public String getPrefix() {
            return this.prefix;
        }

        public static ImmutablePair<SearchMode, String> searchWhat(String text) {
            for (SearchMode mode : SearchMode.values()) {
                Pattern m;
                if (mode == NAME) continue;
                try {
                    m = Pattern.compile("^" + mode.prefix.toLowerCase(), 2);
                }
                catch (Throwable ignore) {
                    try {
                        m = Pattern.compile(Pattern.quote("^" + mode.prefix.toLowerCase()), 2);
                    }
                    catch (Throwable __) {
                        return new ImmutablePair((Object)NAME, (Object)text);
                    }
                }
                if (!m.matcher(text).find()) continue;
                if (mode == UNBIND || mode == BIND || mode == CLICKED) {
                    return ImmutablePair.of((Object)((Object)mode), (Object)text);
                }
                return new ImmutablePair((Object)mode, (Object)text.substring(mode.prefix.length()));
            }
            return new ImmutablePair((Object)NAME, (Object)text);
        }
    }
}

