/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.client.gui.widget;

import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.ITooltip;
import appeng.core.localization.GuiColors;
import codechicken.nei.FormattedTextField;
import codechicken.nei.SearchField;
import codechicken.nei.SearchTextFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;

public class THGuiTextField
extends FormattedTextField {
    private static final int PADDING = 2;
    private final FontRenderer _fontRender;
    private final int fontPad;
    private String tooltip;
    public int x;
    public int y;
    private final int _width;
    private final int _height;
    private int _border;
    private int _color;
    private String suggestion;
    private boolean bg = false;
    public boolean forceDrawSuggestion = false;
    private final TooltipProvider tooltipProvider = new TooltipProvider();
    private String rawSuggestion;
    private static final SearchTextFormatter formatter = new SearchTextFormatter(SearchField.searchParser);

    public THGuiTextField(FontRenderer fontRenderer, int xPos, int yPos, int width, int height) {
        super(fontRenderer, xPos + 2, yPos + 2, width - 4 - fontRenderer.func_78263_a('_'), height - 4);
        this.x = xPos;
        this.y = yPos;
        this._width = width;
        this._height = height;
        this._fontRender = fontRenderer;
        this.tooltip = "";
        this.suggestion = "";
        this.rawSuggestion = "";
        this.fontPad = fontRenderer.func_78263_a('_');
        this.setBackgroundDrawing();
        this.func_146185_a(false);
        this.func_146189_e(true);
        this.func_146203_f(100);
        this.setFormatter((FormattedTextField.TextFormatter)formatter);
    }

    public THGuiTextField(int width, int height, String tooltip) {
        this(Minecraft.func_71410_x().field_71466_p, 0, 0, width, height);
        this.func_146193_g(GuiColors.SearchboxText.getColor());
        this.func_146196_d();
        this.setMessage(tooltip);
    }

    public void setSuggestion(String suggestion) {
        String text = "";
        if (suggestion.startsWith(this.func_146179_b())) {
            int pos = suggestion.indexOf(this.func_146179_b());
            text = suggestion.substring(pos + this.func_146179_b().length());
        }
        this.suggestion = text;
        this.rawSuggestion = suggestion;
    }

    public void updateSuggestion() {
        this.setSuggestion(this.rawSuggestion);
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public String getRawSuggestion() {
        return this.rawSuggestion;
    }

    public void setSuggestionToText() {
        this.func_146180_a(this.rawSuggestion);
        this.setSuggestion(this.rawSuggestion);
    }

    public void func_146194_f() {
        this.setDimensionsAndColor();
        if (this.func_146176_q()) {
            if (this.getBorder() > 0) {
                THGuiTextField.func_73734_a((int)(this.x - this.getBorder()), (int)(this.y - this.getBorder()), (int)(this.field_146209_f + this._width + this.getBorder()), (int)(this.field_146210_g + this._height + this.getBorder()), (int)this.getColor());
            }
            if (this.bg) {
                GuiTextField.func_73734_a((int)(this.x + 1), (int)(this.y + 1), (int)(this.x + this._width - 1), (int)(this.y + this._height - 1), (int)(this.func_146206_l() ? GuiColors.SearchboxFocused.getColor() : GuiColors.SearchboxUnfocused.getColor()));
            }
        }
        this.drawSuggestion();
        try {
            super.func_146194_f();
        }
        catch (Exception e) {
            String text = this.func_146179_b().replaceAll("[^a-zA-Z0-9\\s]", "");
            this.func_146180_a(text);
        }
    }

    public void setBackgroundDrawing() {
        this.bg = true;
    }

    protected void setDimensionsAndColor() {
        this.field_146209_f = this.x + 2;
        this.field_146210_g = this.y + 2;
        this.field_146218_h = this._width - 4 - this.fontPad;
        this.field_146219_i = this._height - 4;
    }

    public void onTextChange(String oldText) {
    }

    private void drawSuggestion() {
        if (this.func_146176_q() && !this.suggestion.isEmpty()) {
            String drawString = this.suggestion;
            if (this._fontRender.func_78256_a(this.rawSuggestion) > this._width) {
                char s;
                int charWidth;
                int w = this._fontRender.func_78256_a(this.func_146179_b());
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < this.suggestion.toCharArray().length && w + (charWidth = this._fontRender.func_78263_a(s = this.suggestion.charAt(i))) * 3 < this._width; ++i) {
                    w += charWidth;
                    builder.append(s);
                }
                drawString = builder.toString();
            }
            this.func_73731_b(this._fontRender, drawString, this.x + 2 + this._fontRender.func_78256_a(this.func_146179_b()), this.y + 2, 0xC0C0C0);
        }
    }

    public void func_146180_a(String text) {
        super.func_146180_a(text);
        String oldText = this.func_146179_b();
        int currentCursorPos = this.func_146198_h();
        this.func_146190_e(currentCursorPos);
        this.onTextChange(oldText);
    }

    public boolean func_146201_a(char keyChar, int keyID) {
        if (!this.func_146206_l()) {
            return false;
        }
        String oldText = this.func_146179_b();
        boolean handled = super.func_146201_a(keyChar, keyID);
        if (!(handled || keyID != 28 && keyID != 156 && keyID != 1)) {
            this.func_146195_b(false);
        }
        if (handled) {
            this.onTextChange(oldText);
        }
        return handled;
    }

    public void handleTooltip(int mouseX, int mouseY, AEBaseGui gui) {
        this.handleTooltip(mouseX, mouseY, gui, 0);
    }

    public void handleTooltip(int mouseX, int mouseY, AEBaseGui gui, int offsetY) {
        if (this.isMouseIn(mouseX, mouseY) && this.tooltip != null && !this.tooltip.isEmpty()) {
            int length = 0;
            for (String s : this.getMessage().split("\n")) {
                length = Math.max(this._fontRender.func_78256_a(s), length);
            }
            if (mouseY < 15) {
                mouseY = 15;
            }
            if (mouseX + length + 20 >= gui.field_146294_l) {
                gui.drawTooltip(mouseX - length - 20, mouseY + 4 + offsetY, 0, this.getMessage());
            } else {
                gui.drawTooltip(mouseX, mouseY + 4 + offsetY, 0, this.getMessage());
            }
        }
    }

    public int getBorder() {
        return this._border;
    }

    public void setBorder(int border) {
        this._border = border;
        this._color = 0;
    }

    public void setBorder(int border, int color) {
        this._border = border;
        this._color = color;
    }

    public void setBorder() {
        this._border = 0;
        this._color = 0;
    }

    public int getColor() {
        return this._color;
    }

    public void setColor(int color) {
        this._color = color;
    }

    public void func_146192_a(int xPos, int yPos, int button) {
        super.func_146192_a(xPos, yPos, button);
        boolean requiresFocus = this.isMouseIn(xPos, yPos);
        this.func_146195_b(requiresFocus);
        if (button == 1 && requiresFocus) {
            this.func_146180_a("");
        }
    }

    public void func_146195_b(boolean focused) {
        super.func_146195_b(focused);
        this.bg = focused;
    }

    public boolean isMouseIn(int xCoord, int yCoord) {
        boolean withinXRange = this.x <= xCoord && xCoord < this.x + this._width;
        boolean withinYRange = this.y <= yCoord && yCoord < this.y + this._height;
        return withinXRange && withinYRange;
    }

    public void setMessage(String t) {
        this.tooltip = t;
    }

    public String getMessage() {
        return this.tooltip;
    }

    public TooltipProvider getTooltipProvider() {
        return this.tooltipProvider;
    }

    public class TooltipProvider
    implements ITooltip {
        public String getMessage() {
            return THGuiTextField.this.tooltip;
        }

        public int xPos() {
            return THGuiTextField.this.x;
        }

        public int yPos() {
            return THGuiTextField.this.y;
        }

        public int getHeight() {
            return THGuiTextField.this._height;
        }

        public int getWidth() {
            return THGuiTextField.this._width;
        }

        public boolean isVisible() {
            return THGuiTextField.this.func_146176_q();
        }
    }
}

